from __future__ import division
from pyomo.environ import *

model = AbstractModel(name = "CWLP_abstract")
model.N = Set()
model.M = Set()
model.d = Param(model.N,model.M)
model.f = Param(model.N)
model.TOL = Param()
model.x = Var(model.N,model.M,bounds = (0,1))
model.y = Var(model.N,within = Binary)

# O codigo abaixo é idêntico ao da modelagem com respresentacao concreta
# exceto pelo acesso aos valores de N,M,P que agora se da por model.N, model.M,model.P

def fobjetivo(model):
    return sum(model.f[n]*model.y[n] for n in model.N) +\
sum(model.d[n,m]* model.x[n,m] for n in model.N \
               for m in model.M)
model.obj = Objective(rule=fobjetivo)

def rest_atribuicao(model,m):
    return sum(model.x[n,m] for n in model.N) == 1
model.ratrib = Constraint(model.M,rule = rest_atribuicao)

def rest_logica(model,n,m):
    return model.x[n,m] <= model.y[n]
model.logica = Constraint(model.N,model.M,rule = rest_logica)
