# modelagem concreta para o CWLP, versao nao capacitada
# arquivo: cwlp_concrete.py

from __future__ import division
from pyomo.environ import *

model = ConcreteModel(name = "CWLP1_Concrete")

N = ['Harlingen','Memphis','Ashlan'] # armazens
M = ['NYC','LA','Chicago','Houston'] # clientes
d = {('Harlingen','NYC'): 1956, \
     ('Harlingen','LA'): 1606,  \
     ('Harlingen','Chicago'): 1410, \
     ('Harlingen','Houston'): 330, \
     ('Memphis','NYC'): 1096, \
     ('Memphis','LA'): 1792, \
     ('Memphis','Chicago'): 531, \
     ('Memphis','Houston'): 567, \
     ('Ashlan','NYC'): 485, \
     ('Ashlan','LA'): 2322, \
     ('Ashlan','Chicago'): 324, \
     ('Ashlan','Houston'): 1236}

f = {'Harlingen': 400, \
     'Memphis': 600, \
     'Ashlan':  150}

TOL = 1.0E-5

model.x = Var(N,M, bounds = (0,1))
model.y = Var(N,within = Binary)

def fobjetivo(model):
    """ Define funcao objetivo do modelo CWLP """
    return (sum(f[n]*model.y[n] for n in N) +\
            sum(d[n,m]*model.x[n,m] for n in N for m in M))
model.obj = Objective(rule=fobjetivo)

def rest_atribuicao(model,m):
    """ Garante que a totalidade da demanda sera atendida """
    return sum(model.x[n,m] for n in N) == 1
model.ratrib = Constraint(M,rule = rest_atribuicao)

def rest_logica(model,n,m):
    return model.x[n,m] <= model.y[n]
model.logica = Constraint(N,M,rule = rest_logica)

