/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class SwappedDataInputStream
extends InputStream {
    InputStream is;
    long pos;

    public SwappedDataInputStream(InputStream is) {
        this.is = is;
    }

    public long curPos() {
        return this.pos;
    }

    public int read() throws IOException {
        int n = this.is.read();
        if (n < 0) {
            return -1;
        }
        ++this.pos;
        return n;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int len) throws IOException {
        int n = this.is.read(b, offset, len);
        if (n < 0) {
            return -1;
        }
        this.pos += (long)n;
        return n;
    }

    public short readShort() throws IOException {
        byte[] b = new byte[]{0, 0};
        int mask = 255;
        short s = 0;
        int n = this.read(b, 0, 2);
        if (n < 2) {
            throw new IOException();
        }
        s = (short)(s | (short)b[1] << 8);
        s = (short)(s | (short)b[0] & mask);
        return s;
    }

    public int readInt() throws IOException {
        byte[] b = new byte[]{0, 0, 0, 0};
        int mask = 255;
        int i = 0;
        int n = this.read(b, 0, 4);
        if (n < 4) {
            throw new IOException();
        }
        i |= ((short)b[3] & mask) << 24;
        i |= ((short)b[2] & mask) << 16;
        i |= ((short)b[1] & mask) << 8;
        return i |= (short)b[0] & mask;
    }

    public int available() throws IOException {
        return this.is.available();
    }

    public void close() throws IOException {
        this.is.close();
    }

    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void reset() throws IOException {
        this.is.reset();
        this.pos = 0L;
    }

    public long skip(long n) throws IOException {
        long m = this.is.skip(n);
        this.pos += m;
        return m;
    }
}

