/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;

class Win3BMPFile {
    Win3BMPFileHeader fileHeader;
    Win3BitmapHeader bitmapHeader;
    Win3ColorPalette palette;
    int rawOffset;
    byte[] rawData;
    byte[] byteData;
    int[] intData;

    public void read(InputStream is) throws IOException, Exception {
        SwappedDataInputStream dis = new SwappedDataInputStream(is);
        this.fileHeader = new Win3BMPFileHeader();
        this.fileHeader.read(dis);
        this.bitmapHeader = new Win3BitmapHeader();
        this.bitmapHeader.read(dis);
        this.palette = new Win3ColorPalette(this.bitmapHeader);
        this.palette.read(dis);
        long skip = (long)this.fileHeader.bitmapOffset - dis.curPos();
        if (skip > 0L) {
            dis.skip(skip);
        }
        int len = this.bitmapHeader.scanLineSize;
        if (this.bitmapHeader.bitsPerPixel > 8) {
            this.intData = new int[this.bitmapHeader.width * this.bitmapHeader.height];
        } else {
            this.byteData = new byte[this.bitmapHeader.width * this.bitmapHeader.height];
        }
        this.rawData = this.bitmapHeader.compression == 0 ? new byte[this.bitmapHeader.actualSizeOfBitmap] : new byte[this.bitmapHeader.width * this.bitmapHeader.height];
        this.rawOffset = 0;
        int offset = (this.bitmapHeader.height - 1) * this.bitmapHeader.width;
        int i = this.bitmapHeader.height - 1;
        while (i >= 0) {
            switch (this.bitmapHeader.compression) {
                case 0: {
                    int n = dis.read(this.rawData, this.rawOffset, len);
                    if (n < len) {
                        throw new Exception("Scan line ended prematurely after " + n + " bytes");
                    }
                    if (this.bitmapHeader.bitsPerPixel > 8) {
                        this.unpack(this.rawData, this.rawOffset, this.intData, offset, this.bitmapHeader.width);
                    } else {
                        this.unpack(this.rawData, this.rawOffset, this.bitmapHeader.bitsPerPixel, this.byteData, offset, this.bitmapHeader.width);
                    }
                    this.rawOffset += len;
                    break;
                }
                case 1: {
                    throw new Exception("8 bit RLE encoding not yet supported");
                }
                case 2: {
                    int sOffset = this.rawOffset;
                    this.read4Bitline(dis, this.bitmapHeader.width);
                    int j = 0;
                    while (j < this.bitmapHeader.width) {
                        this.byteData[offset + j] = this.rawData[sOffset + j];
                        ++j;
                    }
                    break;
                }
                default: {
                    throw new Exception("Unsupported compression option");
                }
            }
            offset -= this.bitmapHeader.width;
            --i;
        }
    }

    void read4Bitline(SwappedDataInputStream dis, int len) throws Exception {
        int secondByte;
        int firstByte;
        int nSet = 0;
        block8: while (nSet < len) {
            firstByte = this.read1Byte(dis);
            switch (firstByte) {
                case 0: {
                    byte firstColor;
                    byte colors;
                    secondByte = this.read1Byte(dis);
                    switch (secondByte) {
                        case 0: {
                            throw new Exception("Premature end of line in RLE4 format");
                        }
                        case 1: {
                            throw new Exception("Premature end bitmap in RLE4 format");
                        }
                        case 2: {
                            throw new Exception("Deltas not supported");
                        }
                    }
                    int nColorIndexes = (secondByte & 0xFFFFFF80) != 0 ? 128 + (secondByte & 0x7F) : secondByte;
                    byte secondColor = 0;
                    boolean getAByte = true;
                    boolean evenBytes = true;
                    int i = 1;
                    while (i <= nColorIndexes) {
                        if (nSet < len) {
                            if (getAByte) {
                                colors = this.read1Byte(dis);
                                evenBytes = !evenBytes;
                                firstColor = this.lowOrderNibble(colors);
                                secondColor = this.highOrderNibble(colors);
                                this.rawData[this.rawOffset] = firstColor;
                            } else {
                                this.rawData[this.rawOffset] = secondColor;
                            }
                            getAByte = !getAByte;
                            ++nSet;
                            ++this.rawOffset;
                        }
                        ++i;
                    }
                    if (evenBytes) continue block8;
                    byte dummy = this.read1Byte(dis);
                    break;
                }
                default: {
                    int nPixels = (firstByte & 0xFFFFFF80) != 0 ? 128 + (firstByte & 0x7F) : firstByte;
                    byte colors = this.read1Byte(dis);
                    byte firstColor = this.lowOrderNibble(colors);
                    byte secondColor = this.highOrderNibble(colors);
                    boolean first = true;
                    while (nPixels > 0) {
                        if (nSet < len) {
                            this.rawData[this.rawOffset] = first ? firstColor : secondColor;
                            first = !first;
                            ++nSet;
                            ++this.rawOffset;
                        }
                        --nPixels;
                    }
                    continue block8;
                }
            }
        }
        firstByte = this.read1Byte(dis);
        secondByte = this.read1Byte(dis);
        if (firstByte != 0 || secondByte != 0) {
            throw new Exception("End of line was expected in RLE4 format");
        }
        if (nSet != len) {
            throw new Exception("Line length was:" + nSet + " expected value is:" + len);
        }
    }

    byte highOrderNibble(byte aByte) {
        return (byte)(aByte & 0xF);
    }

    byte lowOrderNibble(byte aByte) {
        byte shifted = (byte)(aByte >> 4);
        return (byte)(shifted & 0xF);
    }

    byte read1Byte(SwappedDataInputStream dis) throws Exception {
        byte[] oneByte = new byte[1];
        int n = dis.read(oneByte, 0, 1);
        if (n == 0) {
            throw new Exception("Premature end of data in 4BIT RLE data");
        }
        return oneByte[0];
    }

    void unpack(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
        int j = intOffset;
        int k = rawOffset;
        int mask = 255;
        int i = 0;
        while (i < w) {
            int b0 = rawData[k++] & mask;
            int b1 = (rawData[k++] & mask) << 8;
            int b2 = (rawData[k++] & mask) << 16;
            intData[j] = -16777216;
            int n = j;
            intData[n] = intData[n] | b0;
            int n2 = j;
            intData[n2] = intData[n2] | b1;
            int n3 = j++;
            intData[n3] = intData[n3] | b2;
            ++i;
        }
    }

    void unpack(byte[] rawData, int rawOffset, int bpp, byte[] byteData, int byteOffset, int w) throws Exception {
        int pixPerByte;
        int mask;
        int j = byteOffset;
        int k = rawOffset;
        switch (bpp) {
            case 1: {
                mask = 1;
                pixPerByte = 8;
                break;
            }
            case 4: {
                mask = 15;
                pixPerByte = 2;
                break;
            }
            case 8: {
                mask = -1;
                pixPerByte = 1;
                break;
            }
            default: {
                throw new Exception("Unsupported bits-per-pixel value");
            }
        }
        int i = 0;
        while (true) {
            int shift = 8 - bpp;
            int ii = 0;
            while (ii < pixPerByte) {
                byte br = rawData[k];
                br = (byte)(br >> shift);
                byteData[j] = (byte)(br & mask);
                ++j;
                if (++i == w) {
                    return;
                }
                shift -= bpp;
                ++ii;
            }
            ++k;
        }
    }

    public MemoryImageSource makeImageSource() {
        ColorModel cm = this.palette.noOfEntries > 0 ? new IndexColorModel((int)this.bitmapHeader.bitsPerPixel, this.palette.noOfEntries, this.palette.r, this.palette.g, this.palette.b) : ColorModel.getRGBdefault();
        MemoryImageSource mis = this.bitmapHeader.bitsPerPixel > 8 ? new MemoryImageSource(this.bitmapHeader.width, this.bitmapHeader.height, cm, this.intData, 0, this.bitmapHeader.width) : new MemoryImageSource(this.bitmapHeader.width, this.bitmapHeader.height, cm, this.byteData, 0, this.bitmapHeader.width);
        return mis;
    }

    Win3BMPFile() {
    }
}

