/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;

public class KSLSplitterPanel
extends Panel {
    private Dimension curDim;
    private Point curLoc;
    private boolean dimChanged = true;
    private Panel topPanel;
    private int lastTopHeight;
    private int lastBottomHeight;
    private Panel bottomPanel;
    private boolean displayBottomPanel;
    private boolean doMoveSplit;
    private int moveFromY;
    private static final int borderSize = 0;
    private static final int gapSize = 6;
    private static final Color gapColor = Color.lightGray;

    public KSLSplitterPanel(Panel panel, Panel panel2, boolean bl) {
        this.setLayout(null);
        this.topPanel = panel;
        this.bottomPanel = panel2;
        this.add(panel);
        this.add(panel2);
        this.displayBottomPanel = bl;
        this.lastTopHeight = 1;
        this.lastBottomHeight = 1;
        this.curDim = new Dimension(-1, -1);
        this.curLoc = new Point(-1, -1);
    }

    public void drawGap(Graphics graphics) {
        int n = this.bottomPanel.location().y - 6 + 1;
        graphics.setColor(Color.white);
        graphics.fillRect(0, n, this.size().width, 1);
        graphics.setColor(Color.darkGray);
        graphics.fillRect(0, n += 3, this.size().width, 1);
        graphics.setColor(Color.black);
        graphics.fillRect(0, ++n, this.size().width, 1);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 503: {
                if (event.target == this && this.inGap(event.x, event.y)) {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                } else {
                    this.setCursor(Cursor.getDefaultCursor());
                }
                return true;
            }
            case 501: {
                if (event.target != this || !this.inGap(event.x, event.y)) break;
                this.doMoveSplit = true;
                this.moveFromY = event.y;
                return true;
            }
            case 506: {
                if (!this.doMoveSplit) break;
                return true;
            }
            case 502: {
                if (!this.doMoveSplit) break;
                this.moveSplit(event.y - this.moveFromY);
                this.doMoveSplit = false;
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void hideBottomPanel() {
        if (this.displayBottomPanel) {
            this.displayBottomPanel = false;
            this.dimChanged = true;
            this.bottomPanel.hide();
            this.repaint();
        }
    }

    public boolean inGap(int n, int n2) {
        int n3 = 0;
        int n4 = this.bottomPanel.location().y - 6;
        int n5 = this.size().width;
        int n6 = 6;
        Rectangle rectangle = new Rectangle(n3, n4, n5, n6);
        return rectangle.inside(n, n2);
    }

    public synchronized void layout() {
        this.placeComponents();
    }

    public void moveSplit(int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.topPanel.location().x;
        int n3 = this.topPanel.location().y;
        int n4 = this.topPanel.size().width;
        int n5 = this.topPanel.size().height + n;
        int n6 = this.bottomPanel.location().x;
        int n7 = this.bottomPanel.location().y + n;
        int n8 = this.bottomPanel.size().width;
        int n9 = this.bottomPanel.size().height - n;
        if (n5 > 20 && n9 > 20) {
            this.topPanel.reshape(n2, n3, n4, n5);
            this.bottomPanel.reshape(n6, n7, n8, n9);
            this.lastTopHeight = n5;
            this.lastBottomHeight = n9;
            this.topPanel.layout();
            this.topPanel.invalidate();
            this.topPanel.validate();
            this.topPanel.repaint();
            this.bottomPanel.layout();
            this.bottomPanel.invalidate();
            this.bottomPanel.validate();
            this.bottomPanel.repaint();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.dimChanged) {
            this.placeComponents();
        }
        Dimension dimension = this.size();
        graphics.setColor(gapColor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        this.drawGap(graphics);
        super.paint(graphics);
    }

    public void placeComponents() {
        this.dimChanged = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.size().width;
        int n4 = this.size().height - 6;
        int n5 = this.displayBottomPanel ? n4 * this.lastTopHeight / (this.lastTopHeight + this.lastBottomHeight) : n4;
        this.topPanel.reshape(n, n2, n3, n5);
        this.topPanel.layout();
        this.topPanel.invalidate();
        this.topPanel.validate();
        this.topPanel.repaint();
        if (this.displayBottomPanel) {
            int n6 = n2 + n5 + 6;
            int n7 = n4 - n5;
            this.bottomPanel.reshape(n, n6, n3, n7);
            this.bottomPanel.invalidate();
            this.bottomPanel.validate();
            this.bottomPanel.repaint();
        }
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.curDim.width != n3 || this.curDim.height != n4 || this.curLoc.x != n || this.curLoc.y != n2) {
            this.dimChanged = true;
            this.curDim.width = n3;
            this.curDim.height = n4;
            this.curLoc.x = n;
            this.curLoc.y = n2;
        }
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void showBottomPanel() {
        if (!this.displayBottomPanel) {
            this.displayBottomPanel = true;
            this.dimChanged = true;
            this.bottomPanel.show();
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

