/*
 * Decompiled with CFR 0.152.
 */
import java.awt.FontMetrics;
import java.util.Vector;

public class TextScanner {
    private int charCount;
    private int lineWidth;
    private char[] cText;
    private int nLines;
    private Vector lines;
    private FontMetrics fm;

    TextScanner(String string, int n, FontMetrics fontMetrics) {
        this.lineWidth = n;
        this.fm = fontMetrics;
        this.setText(string);
    }

    void addLine(int n, int n2) {
        ++this.nLines;
        this.lines.addElement(new String(this.cText, n, n2 - n + 1));
    }

    void addLine(String string) {
        ++this.nLines;
        this.lines.addElement(new String(string));
    }

    private String alignText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (this.isBiDi(c)) {
                int n3 = n2++;
                while (n2 < n) {
                    c = stringBuffer.charAt(n2);
                    if (this.isSpace(c)) {
                        if (n2 + 1 >= n || !this.isBiDi(stringBuffer.charAt(n2 + 1))) break;
                        ++n2;
                    } else if (!this.isBiDi(c)) break;
                    ++n2;
                }
                int n4 = n2 - 1;
                while (n3 < n4) {
                    c = stringBuffer.charAt(n3);
                    stringBuffer.setCharAt(n3, stringBuffer.charAt(n4));
                    stringBuffer.setCharAt(n4, c);
                    ++n3;
                    --n4;
                }
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void breakLine(char[] cArray, int n, int n2) throws CantBreakLineException {
        boolean bl = true;
        int n3 = n2;
        while ((cArray[n3] == ' ' || cArray[n3] == '\t') && n3 > n) {
            --n3;
        }
        int n4 = n;
        int n5 = n - 1;
        int n6 = n - 1;
        while (n4 <= n3) {
            char c = cArray[n4];
            if (c == ' ' || c == '\t' || n4 == n3) {
                if (n4 == n3) {
                    ++n4;
                    bl = false;
                }
                if (!bl) {
                    int n7 = n4 - 1;
                    int n8 = n5 + 1;
                    int n9 = this.fm.charsWidth(cArray, n5 + 1, n7 - n8 + 1);
                    if (n9 >= this.lineWidth || n4 > n3) {
                        if (n9 >= this.lineWidth) {
                            if (n6 >= n) {
                                this.addLine(new String(cArray, n5 + 1, n6 - n5 - 1));
                                n5 = n6;
                                n6 = n - 1;
                                if (--n4 == n3) {
                                    --n4;
                                }
                            } else {
                                int n10 = 0;
                                int n11 = n5 + 1;
                                int n12 = n5;
                                while (n10 < this.lineWidth) {
                                    n10 += this.fm.charWidth(cArray[++n12]);
                                }
                                if (--n12 < n11) throw new CantBreakLineException();
                                this.addLine(new String(cArray, n11, n12 - n11 + 1));
                                n6 = n - 1;
                                n5 = n12;
                                if (--n4 == n3) {
                                    --n4;
                                }
                            }
                        } else {
                            this.addLine(new String(cArray, n8, n7 - n8 + 1));
                            n5 = n4;
                            n6 = n - 1;
                        }
                    } else {
                        n6 = n4;
                    }
                }
            } else {
                bl = false;
            }
            ++n4;
        }
    }

    private void breakText() throws CantBreakLineException {
        this.nLines = 0;
        this.lines = new Vector();
        int n = 0;
        int n2 = this.charCount - 1;
        int n3 = -1;
        boolean bl = false;
        while (n <= n2) {
            if (this.cText[n] == '\r' || this.cText[n] == '\n' || n == n2) {
                int n4;
                int n5;
                int n6;
                int n7;
                if (n == n2) {
                    ++n;
                }
                if ((n7 = this.fm.charsWidth(this.cText, n6 = n3 + 1, n5 = (n4 = n - 1) - n6 + 1)) <= this.lineWidth) {
                    if (bl) {
                        this.addLine(this.alignText(new String(this.cText, n6, n4 - n6 + 1)));
                    } else {
                        this.addLine(n6, n4);
                    }
                } else if (bl) {
                    int n8 = n4 - n6 + 1;
                    String string = this.alignText(new String(this.cText, n6, n4 - n6 + 1));
                    char[] cArray = new char[n8];
                    string.getChars(0, n8, cArray, 0);
                    this.breakLine(cArray, 0, n8 - 1);
                    cArray = null;
                } else {
                    this.breakLine(this.cText, n6, n4);
                }
                bl = false;
                if (n >= n2 || this.cText[n] != '\r' || this.cText[n + 1] == '\n') {
                    // empty if block
                }
                n3 = ++n;
            } else if (!bl && this.isBiDi(this.cText[n])) {
                bl = true;
            }
            ++n;
        }
    }

    private void clear() {
        this.charCount = 0;
        this.nLines = 0;
        this.lines = null;
        this.cText = null;
    }

    public String getLineAt(int n) {
        if (n >= 0 && n < this.nLines) {
            return (String)this.lines.elementAt(n);
        }
        return null;
    }

    public Vector getLines() {
        return this.lines;
    }

    public int getNumberOfLines() {
        return this.nLines;
    }

    private boolean isBiDi(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    private void reBreak() {
        block2: {
            if (this.charCount <= 0) break block2;
            try {
                this.breakText();
            }
            catch (CantBreakLineException cantBreakLineException) {
                this.nLines = 0;
                this.lines = null;
            }
        }
    }

    public void setFontMetrics(FontMetrics fontMetrics) {
        this.fm = fontMetrics;
        this.reBreak();
    }

    public void setLineWidth(int n) {
        if (this.lineWidth != n) {
            this.lineWidth = n;
            this.reBreak();
        }
    }

    public void setText(String string) {
        if (string != null) {
            this.charCount = string.length();
            if (this.charCount > 0) {
                this.cText = new char[this.charCount];
                int n = this.charCount - 1;
                string.getChars(0, this.charCount, this.cText, 0);
                char c = this.cText[n];
                while ((this.cText[n] == ' ' || this.cText[n] == '\t') && this.charCount > 0) {
                    --n;
                    --this.charCount;
                }
                this.reBreak();
            } else {
                this.clear();
            }
        } else {
            this.clear();
        }
    }
}

