/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class TreeView
extends Panel {
    public static final int CHILD = 0;
    public static final int NEXT = 1;
    public static final int LAST = 2;
    private TreeNode rootNode;
    private TreeNode selectedNode;
    private TreeNode topVisibleNode;
    Scrollbar sbV;
    int sbVPosition = 0;
    int sbVWidth = 16;
    long sbVTimer = -1L;
    private int count = 0;
    private int viewCount = 0;
    private Color bgHighlightColor = new Color(0, 0, 128);
    private Color fgHighlightColor = Color.white;
    private int viewHeight = 0;
    private int viewWidth = 0;
    int cellSize = 16;
    int clickSize = 8;
    int imageInset = 3;
    int textInset = 6;
    int textBaseLine = 3;
    private FontMetrics fm;
    long timeMouseDown;
    int doubleClickResolution = 333;
    protected Image im1;
    protected Graphics g1 = null;
    private static Hashtable imageDictionary = new Hashtable();
    private Applet myApplet;
    private Vector e;
    private Vector v;

    public TreeView(Applet applet) {
        super.setLayout(new BorderLayout());
        this.sbV = new Scrollbar(1);
        this.add("East", this.sbV);
        this.myApplet = applet;
    }

    public TreeView(Applet applet, TreeNode treeNode) {
        this(applet);
        this.addRoot(treeNode);
    }

    void addChild(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode2.child == null) {
            treeNode2.child = treeNode;
            treeNode.parent = treeNode2;
            ++this.count;
        } else {
            this.addSibling(treeNode, treeNode2.child);
        }
        ++treeNode2.numberOfChildren;
    }

    public void addRoot(TreeNode treeNode) {
        this.selectedNode = null;
        this.rootNode = treeNode;
        this.count = 1;
    }

    void addSibling(TreeNode treeNode, TreeNode treeNode2) {
        TreeNode treeNode3 = treeNode2;
        while (treeNode3.sibling != null) {
            treeNode3 = treeNode3.sibling;
        }
        treeNode3.sibling = treeNode;
        treeNode.parent = treeNode3.parent;
        ++this.count;
    }

    private String alignText(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (this.isBiDi(c)) {
                int n3 = n2++;
                while (n2 < n) {
                    c = stringBuffer.charAt(n2);
                    if (this.isSpace(c)) {
                        if (n2 + 1 >= n || !this.isBiDi(stringBuffer.charAt(n2 + 1))) break;
                        ++n2;
                    } else if (!this.isBiDi(c)) break;
                    ++n2;
                }
                int n4 = n2 - 1;
                while (n3 < n4) {
                    c = stringBuffer.charAt(n3);
                    stringBuffer.setCharAt(n3, stringBuffer.charAt(n4));
                    stringBuffer.setCharAt(n4, c);
                    ++n3;
                    --n4;
                }
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    private void changeSelection(TreeNode treeNode) {
        if (treeNode == this.selectedNode) {
            return;
        }
        TreeNode treeNode2 = this.selectedNode;
        this.selectedNode = treeNode;
        if (treeNode2 != null) {
            this.drawNodeText(treeNode2, (this.v.indexOf(treeNode2) - this.sbVPosition) * this.cellSize, true);
        }
        this.drawNodeText(treeNode, (this.v.indexOf(treeNode) - this.sbVPosition) * this.cellSize, true);
        this.sendSelectedEvent();
        int n = this.v.indexOf(this.selectedNode);
        if (n < this.sbVPosition) {
            --this.sbVPosition;
            this.sbV.setValue(this.sbVPosition);
            this.redraw();
            return;
        }
        if (n >= this.sbVPosition + (this.viewHeight - this.cellSize / 2) / this.cellSize) {
            ++this.sbVPosition;
            this.sbV.setValue(this.sbVPosition);
            this.redraw();
            return;
        }
        this.repaint();
    }

    private void drawDotLine(int n, int n2, int n3, int n4) {
        this.g1.setColor(Color.gray);
        if (n2 == n4) {
            int n5 = n;
            while (n5 < n3) {
                this.g1.drawLine(n5, n2, n5, n4);
                n5 += 2;
            }
        } else {
            int n6 = n2;
            while (n6 < n4) {
                this.g1.drawLine(n, n6, n3, n6);
                n6 += 2;
            }
        }
    }

    private void drawNodeText(TreeNode treeNode, int n, boolean bl) {
        Color color;
        Color color2;
        int n2 = treeNode.depth;
        int n3 = (n2 + 1) * this.cellSize + this.cellSize + this.textInset;
        if (treeNode == this.selectedNode) {
            color2 = this.fgHighlightColor;
            color = this.bgHighlightColor;
        } else {
            color2 = Color.black;
            color = Color.white;
        }
        if (bl) {
            this.g1.setColor(color);
            this.g1.fillRect(n3 - 1, n + 1, this.fm.stringWidth(treeNode.text) + 4, this.cellSize - 1);
        }
        this.g1.setColor(color2);
        this.g1.drawString(this.alignText(treeNode.text), n3, n + this.cellSize - this.textBaseLine);
    }

    public synchronized void drawTree() {
        Dimension dimension = this.size();
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight || this.g1 == null) {
            this.im1 = this.createImage(dimension.width, dimension.height);
            if (this.g1 != null) {
                this.g1.dispose();
            }
            this.g1 = this.im1.getGraphics();
            this.viewWidth = dimension.width;
            this.viewHeight = dimension.height;
        }
        Font font = new Font("Dialog", 0, 12);
        this.g1.setFont(font);
        this.setFont(font);
        this.fm = this.g1.getFontMetrics();
        this.g1.setColor(Color.white);
        this.g1.fillRect(0, 0, this.viewWidth, this.viewHeight);
        int n = this.sbVPosition + this.viewHeight / this.cellSize;
        if (n > this.viewCount) {
            n = this.viewCount;
        }
        int n2 = this.sbVPosition;
        while (n2 < n) {
            Object object;
            int n3;
            TreeNode treeNode = (TreeNode)this.v.elementAt(n2);
            int n4 = this.cellSize * (treeNode.depth + 1);
            int n5 = (n2 - this.sbVPosition) * this.cellSize;
            this.g1.setColor(Color.black);
            if (treeNode.sibling != null) {
                n3 = this.v.indexOf(treeNode.sibling) - n2;
                if (n3 > n) {
                    n3 = n;
                }
                this.drawDotLine(n4 - this.cellSize / 2, n5 + this.cellSize / 2, n4 - this.cellSize / 2, n5 + this.cellSize / 2 + n3 * this.cellSize);
            }
            n3 = 0;
            while (n3 < n2) {
                object = (TreeNode)this.v.elementAt(n3);
                if (((TreeNode)object).sibling == treeNode && n3 < this.sbVPosition) {
                    this.drawDotLine(n4 - this.cellSize / 2, 0, n4 - this.cellSize / 2, n5 + this.cellSize / 2);
                }
                ++n3;
            }
            if (treeNode.isExpanded()) {
                this.drawDotLine(n4 + this.cellSize / 2, n5 + this.cellSize, n4 + this.cellSize / 2, n5 + this.cellSize + this.cellSize / 2);
            }
            this.g1.setColor(Color.black);
            this.drawDotLine(n4 - this.cellSize / 2, n5 + this.cellSize / 2, n4 + this.cellSize / 2, n5 + this.cellSize / 2);
            if (treeNode.isExpandable()) {
                this.g1.setColor(Color.white);
                this.g1.fillRect(this.cellSize * treeNode.depth + this.cellSize / 4, n5 + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.setColor(Color.gray);
                this.g1.drawRect(this.cellSize * treeNode.depth + this.cellSize / 4, n5 + this.clickSize / 2, this.clickSize, this.clickSize);
                this.g1.setColor(Color.black);
                this.g1.drawLine(this.cellSize * treeNode.depth + this.cellSize / 4 + 2, n5 + this.cellSize / 2, this.cellSize * treeNode.depth + this.cellSize / 4 + this.clickSize - 2, n5 + this.cellSize / 2);
                if (!treeNode.isExpanded()) {
                    this.g1.drawLine(this.cellSize * treeNode.depth + this.cellSize / 2, n5 + this.clickSize / 2 + 2, this.cellSize * treeNode.depth + this.cellSize / 2, n5 + this.clickSize / 2 + this.clickSize - 2);
                }
            }
            if (treeNode.text != null) {
                this.drawNodeText(treeNode, n5, treeNode == this.selectedNode);
            }
            if ((object = treeNode.getImage()) != null) {
                this.g1.drawImage((Image)object, n4 + this.imageInset, n5, this);
            }
            ++n2;
        }
    }

    public boolean exists(TreeNode treeNode) {
        this.recount();
        int n = 0;
        while (n < this.count) {
            if (treeNode == this.e.elementAt(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Applet getApplet() {
        return this.myApplet;
    }

    public int getCount() {
        return this.count;
    }

    public Image getImage(URL uRL) {
        Image image = (Image)imageDictionary.get(uRL);
        if (image == null) {
            image = this.myApplet.getImage(uRL);
            imageDictionary.put(uRL, image);
        }
        return image;
    }

    public TreeNode getSelectedNode() {
        return this.selectedNode;
    }

    public String getSelectedText() {
        if (this.selectedNode == null) {
            return null;
        }
        return this.selectedNode.getText();
    }

    public int getViewCount() {
        return this.viewCount;
    }

    public boolean handleEvent(Event event) {
        if (event.target == this.sbV) {
            if (event.arg == null) {
                return false;
            }
            if (this.sbVPosition != (Integer)event.arg) {
                this.sbVPosition = (Integer)event.arg;
                this.redraw();
                return false;
            }
        }
        return super.handleEvent(event);
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (n == 32) {
            this.drawTree();
            this.repaint();
            return false;
        }
        return true;
    }

    public void insert(TreeNode treeNode, TreeNode treeNode2, int n) {
        if (treeNode == null || treeNode2 == null) {
            return;
        }
        if (!this.exists(treeNode2)) {
            return;
        }
        switch (n) {
            case 0: {
                this.addChild(treeNode, treeNode2);
                break;
            }
            case 1: {
                this.addSibling(treeNode, treeNode2);
                break;
            }
            case 2: {
                this.addSibling(treeNode, treeNode2);
                break;
            }
            default: {
                return;
            }
        }
    }

    private boolean isBiDi(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    private boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }

    public boolean keyDown(Event event, int n) {
        if (this.selectedNode == null) {
            return false;
        }
        int n2 = this.v.indexOf(this.selectedNode);
        switch (n) {
            case 10: {
                this.sendActionEvent(event);
                break;
            }
            case 1003: {
                this.sbVPosition = this.sbVPosition + this.sbV.getPageIncrement() <= this.sbV.getMaximum() ? (this.sbVPosition += this.sbV.getPageIncrement()) : this.sbV.getMaximum();
                this.redraw();
                break;
            }
            case 1002: {
                this.sbVPosition = this.sbVPosition - this.sbV.getPageIncrement() >= this.sbV.getMinimum() ? (this.sbVPosition -= this.sbV.getPageIncrement()) : this.sbV.getMinimum();
                this.redraw();
                break;
            }
            case 1006: {
                if (this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle(this);
                    this.redraw();
                    break;
                }
            }
            case 1004: {
                if (n2 <= 0) break;
                this.changeSelection((TreeNode)this.v.elementAt(--n2));
                this.requestFocus();
                break;
            }
            case 1007: {
                if (this.selectedNode.isExpandable() && !this.selectedNode.isExpanded()) {
                    this.selectedNode.toggle(this);
                    this.redraw();
                    break;
                }
                if (!this.selectedNode.isExpandable()) break;
            }
            case 1005: {
                if (n2 >= this.viewCount - 1) break;
                this.changeSelection((TreeNode)this.v.elementAt(++n2));
                this.requestFocus();
                break;
            }
        }
        return false;
    }

    public synchronized Dimension minimumSize() {
        return new Dimension(50, 50);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        int n3 = n2 / this.cellSize + this.sbVPosition;
        if (n3 > this.viewCount - 1) {
            return false;
        }
        TreeNode treeNode = this.selectedNode;
        TreeNode treeNode2 = (TreeNode)this.v.elementAt(n3);
        int n4 = treeNode2.getDepth();
        this.changeSelection(treeNode2);
        Rectangle rectangle = new Rectangle(this.cellSize * n4 + this.cellSize / 4, (n3 - this.sbVPosition) * this.cellSize + this.clickSize / 2, this.clickSize, this.clickSize);
        if (rectangle.inside(n, n2)) {
            treeNode2.toggle(this);
            this.redraw();
        } else {
            long l = event.when;
            if (treeNode2 == treeNode && event.when - this.timeMouseDown < (long)this.doubleClickResolution) {
                this.sendActionEvent(event);
                this.redraw();
                return false;
            }
            this.timeMouseDown = event.when;
        }
        return true;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (dimension.width != this.viewWidth || dimension.height != this.viewHeight) {
            this.redraw();
        }
        graphics.drawImage(this.im1, 0, 0, this);
    }

    public synchronized Dimension preferredSize() {
        return new Dimension(175, 125);
    }

    private void recount() {
        this.count = 0;
        this.e = new Vector();
        if (this.rootNode != null) {
            this.rootNode.depth = 0;
            this.traverse(this.rootNode);
        }
    }

    public void redraw() {
        this.resetVector();
        int n = this.size().height;
        if (this.viewCount > n / this.cellSize) {
            this.sbV.setValues(this.sbVPosition, n / this.cellSize, 0, this.viewCount - 2);
            int n2 = n / 2 / this.cellSize;
            if (n2 <= 0) {
                n2 = 1;
            }
            this.sbV.setPageIncrement(n2);
            this.sbVWidth = 16;
            this.sbV.show();
            this.layout();
        } else {
            this.sbV.hide();
            this.sbVWidth = 0;
            this.sbVPosition = 0;
            this.layout();
        }
        this.drawTree();
        this.repaint();
    }

    private void resetVector() {
        this.v = new Vector(this.count);
        if (this.count < 1) {
            this.viewCount = 0;
            return;
        }
        this.rootNode.depth = 0;
        this.vectorize(this.rootNode);
        this.viewCount = this.v.size();
    }

    private void sendActionEvent(Event event) {
        int n = event.id;
        Object object = event.arg;
        event.id = 1001;
        event.arg = new String(this.selectedNode.getText());
        this.postEvent(event);
        event.id = n;
        event.arg = object;
    }

    private void sendSelectedEvent() {
        Event event = new Event(this, 701, this.selectedNode);
        this.postEvent(event);
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    private void traverse(TreeNode treeNode) {
        ++this.count;
        this.e.addElement(treeNode);
        if (treeNode.child != null) {
            treeNode.child.depth = treeNode.depth + 1;
            this.traverse(treeNode.child);
        }
        if (treeNode.sibling != null) {
            treeNode.sibling.depth = treeNode.depth;
            this.traverse(treeNode.sibling);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void vectorize(TreeNode treeNode) {
        if (treeNode == null) {
            return;
        }
        this.v.addElement(treeNode);
        if (treeNode.isExpanded()) {
            treeNode.child.depth = treeNode.depth + 1;
            this.vectorize(treeNode.child);
        }
        if (treeNode.sibling != null) {
            treeNode.sibling.depth = treeNode.depth;
            this.vectorize(treeNode.sibling);
        }
    }
}

