#include <stdlib.h>
#include <stdio.h>

#include "pilha.h"

#define INIT 10
#define NTESTES 20

#define OP_EMPILHA 0
#define OP_DESEMPILHA 1

void operacao_empilha(struct pilha *pilha) {
	int *elemento = malloc(sizeof(int));
	if(!elemento) { perror(NULL); exit(EXIT_FAILURE); }
	*elemento = rand() % 10;
	printf("empilhando %d\n", *elemento);
	empilha(pilha, elemento);
	printf("pilha: ");
	pilha_imprime_inteiros(pilha);
}

void operacao_desempilha(struct pilha *pilha) {
	void *velemento = desempilha(pilha);
	if(velemento == NULL) return;
	int *elemento = velemento;
	printf("desempilhou %d\n", *elemento);
	printf("pilha: ");
	pilha_imprime_inteiros(pilha);
	free(velemento);
}

int main(void) {
	struct pilha *pilha = pilha_criar();

	int i;
	for(i = 0; i < INIT; i++) {
		operacao_empilha(pilha);
	}

	for(i = 0; i < NTESTES; i++) {
		int operacao = rand() % 2;
		if(operacao == OP_EMPILHA) {
			operacao_empilha(pilha);
		} else {
			operacao_desempilha(pilha);
		}
	}

	pilha_liberar(pilha);
	exit(EXIT_SUCCESS);
}
