#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>

#define BUFSZ 1024

void logexit(const char *str)
{
	perror(str);
	exit(EXIT_FAILURE);
}

int main(void)
{
	int s = socket(AF_INET, SOCK_STREAM, 0);
	if(s == -1) logexit("socket");

	struct in_addr addr;
	if(inet_pton(AF_INET, "150.164.9.28", &addr) <= 0) {
		logexit("pton");
	}

	struct sockaddr_in dst;
	dst.sin_family = AF_INET;
	dst.sin_port = htons(5151);
	dst.sin_addr = addr;

	if(-1 == bind(s, (struct sockaddr *)&dst,
				sizeof(dst))) {
		logexit("connect");
	}

	if(-1 == listen(s, 0)) {
		logexit("listen");
	}

	while(1) {
		struct sockaddr caddr;
		socklen_t caddrlen = sizeof(caddr);
		int r = accept(s, &caddr, &caddrlen);
		if(r <= 0) logexit("accept");

		ssize_t count;
		char buf[BUFSZ];
		char bufaddr[BUFSZ];
		count = recv(r, buf, BUFSZ, 0);
		printf("recvd %d %s", (int)count, buf);

		struct sockaddr_in *cinaddr;
		cinaddr = (struct sockaddr_in *)&caddr;
		inet_ntop(AF_INET, &(cinaddr->sin_addr),
				bufaddr, BUFSZ);
		sprintf(buf, "IPv4 %s\n", bufaddr);
		send(r, buf, strlen(buf)+1, 0);

		close(r);
	}

	close(s);
	exit(EXIT_FAILURE);
}
