#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>

#define BUFSZ 1024

void logexit(const char *str)
{
	perror(str);
	exit(EXIT_FAILURE);
}

int main(void)
{
	int s = socket(AF_INET, SOCK_STREAM, 0);
	if(s == -1) logexit("socket");

	struct in_addr addr;
	if(inet_pton(AF_INET, "150.164.0.135", &addr) <= 0) {
		logexit("pton");
	}

	struct sockaddr_in dst;
	dst.sin_family = AF_INET;
	dst.sin_port = htons(80);
	dst.sin_addr = addr;

	if(-1 == connect(s, (struct sockaddr *)&dst,
				sizeof(dst))) {
		logexit("connect");
	}

	char req[] = "GET /dcc/index.php HTTP/1.1\n"
			"Host: www.dcc.ufmg.br\n\n";

	ssize_t count;
	
	count = send(s, req, strlen(req), 0);
	assert(count == strlen(req));

	char buf[BUFSZ];
	count = recv(s, buf, BUFSZ, 0);
	printf("recvd %d bytes\n", (int)count);
	puts(buf);

	exit(EXIT_FAILURE);
}
