#ifndef __DCCTHREAD_HEADER__
#define __DCCTHREAD_HEADER__

#define THREAD_NAME_LEN 256
#define THREAD_STACK_SIZE (1<<16)

typedef struct dccthread dccthread_t;


void dccthread_init(void (*func)(int), int param) __attribute__((noreturn));
/* dccthread_init initializes any state necessary for the threadling
 * library.  it returns 0 on success and -1 on error. */

void dccthread_close(void);

dccthread_t * dccthread_create(const char *name, void (*func)(), int param);
/* allocates and returns a thread handle on success; returns NULL on
 * failure. */

void dccthread_yield(void);
void dccthread_exit(void);
void dccthread_wait(dccthread_t *tid);

dccthread_t * dccthread_self(void);
/* returns the current thread's handle. */
char * dccthread_name(dccthread_t *tid);
/* return a pointer to the string containing this thread's name; the
 * returned string is owned and managed by the library. */

#endif
