file_to_list(FILE, LIST) :- 
  see(FILE), inquire([], LIST), seen.

inquire(IN, OUT):-
  read(Data), (Data == end_of_file -> OUT = IN;
  atom_codes(Data, LData), inquire([LData|IN], OUT) ) . 

perm([], []).
perm(List, [H|Perm]) :- select(H, List, Rest), perm(Rest, Perm).

find_anagram(Dic, A, S) :-
  file_to_list(Dic, L), perm(A, X), member(X, L), name(S, X).

split([], [], []).
split([H|T], [H|T1], L) :- split(T, T1, L).
split([H|T], L, [H|T2]) :- split(T, L, T2).

comb2(L, L1, L2) :- split(L, L1, L2), length(L1, N), length(L2, N).

find_enigma(Dic, A, S1, S2) :-
  file_to_list(Dic, L), comb2(A, W1, W2), perm(W1, X1), member(X1, L), perm(W2, X2), member(X2, L), !, name(S1, X1), name(S2, X2).
