myLength([], 0).
myLength([_|T], N) :- myLength(T, N1), N is N1 + 1.

myLCR([], Acc, Acc).
myLCR([_|T], Acc, N) :- Acc1 is Acc + 1, myLCR(T, Acc1, N).

sum([], Acc, Acc).
sum([H|T], Acc, S) :- Acc1 is Acc + H, sum(T, Acc1, S).

fact(0, 1).
fact(1, 1).
fact(N, F) :- integer(N), N > 1, N1 is N - 1, fact(N1, F1), F is F1 * N.

is_prime(2).
is_prime(P) :- integer(P), \+ is_not_prime(P).

range(I, I, [I], _).
range(B, U, [B|L], Step) :- B < U, B1 is B + Step, range(B1, U, L, Step).

/* The cut operator, !, is here just for efficency: it stops the search,
   once we find a prime factor. */

is_not_prime(N) :- N mod 2 =:= 0, !.
is_not_prime(N) :-
  N1 is floor(sqrt(N)),
  range(3, N1, L, 2),
  member(P, L), !,
  N mod P =:= 0.

gcd(N, N, N).
gcd(X, Y, Z) :- X < Y, Y1 is Y - X, gcd(X, Y1, Z).
gcd(X, Y, Z) :- Y < X, X1 is X - Y, gcd(X1, Y, Z).

subSet([], []).
subSet([H|T], [H|S]) :- subSet(T, S).
subSet([_|T], S) :- subSet(T, S).

intSum(L, N, S) :- subSet(L, S), sum(S, 0, N).

no_check(_, []).
no_check(I/J, [I1/J1|T]) :-
  I =\= I1,
  J =\= J1,
  abs(I - I1) =\= abs(J - J1),
  no_check(I/J, T).

/*
 legal(L) recebe L incognito, e associa L a uma solucao para o problema das
rainhas.
 */

legal([]).
legal([X/Y | Rest]) :-
  legal(Rest),
  member(X, [1,2,3,4,5,6,7,8]),
  member(Y, [1,2,3,4,5,6,7,8]),
  no_check(X/Y, Rest).















