class Visitor:
  "A parameterized list visitor."
  def __init__(self, cb):
    self.cb = cb
  def __str__(self):
    return "Visitor with callback: {0}".format(self.cb)
  def visit(self, n):
    for i in range(0, len(n)):
      n[i] = self.cb.update(n[i])
    return n

class CallbackBase:
  "The basic callback"
  def __init__(self):
    self.f = lambda x: x+1
  def __str__(self):
    return "basic callback"
  def shouldUpdate(self, i):
    return True
  def update(self, i):
    return self.f(i) if self.shouldUpdate(i) else i

# l = [0, 1, 2, 3]
# cb = CallbackBase()
# v = Visitor(cb)
# v.visit(l)

class CallbackEven(CallbackBase):
  def __str__(self):
    return "even callback"
  def shouldUpdate(self, i):
    return i % 2 == 0

# v0 = Visitor(CallbackBase())
# v1 = Visitor(CallbackEven())
# v0.visit([0,1,2,3])
# v1.visit([0,1,2,3])

class CallbackDouble(CallbackBase):
  def __init__(self):
    self.f = lambda x: 2*x
  def __str__(self):
    return "double callback"

# v = Visitor(CallbackDouble())
# v.visit([0,1,2,3])

class CallbackComb(CallbackDouble, CallbackEven):
  def __str__(self):
    return "the combining callback"

# v = Visitor(CallbackComb())
# v.visit([0,1,2,3])

class CallbackOtherComb(CallbackDouble, CallbackEven):
  def update(self, i):
    return self.f(self.f(i)) if self.shouldUpdate(i) else i

# v = Visitor(CallbackOtherComb())
# v.visit([0,1,2,3])
# print(v)

# python applies linearization of the inheritance order, thus clashes are resolved according to the order:
#   CallbackOtherComb -> CallbackDouble -> CallbackEven -> CallbackBase
