class ArithmeticException(Exception):
  def __init__(self, msg):
    self.value = msg
  def __str__(self):
    return repr(self.value)

def div(n, d):
  if d == 0:
    raise ArithmeticException("Attempt to divide " + str(n) + " by zero")
  else:
    return n/d

while True:
  try:
    n = float(input("Please, enter the dividend: "))
    d = float(input("Please, enter the divisor: "))
    r = div(n, d)
    print("Result =", r)
  except ValueError:
    print("Invalid number format. Please, try again")
  except ArithmeticException as ae:
    print(ae.value)
    break
  finally:
    print("We do this regardless")
