#include <memory>

#include <assert.h>

#include <iostream>  // std::cout

class EmptyStackException : public std::exception
{
 public:
  std::string d_msg;
  EmptyStackException(const std::string& msg) : d_msg(msg) {}
  // overridden from base class std::exception
  const char* what() const noexcept override { return d_msg.c_str(); }
};

/* dynamic stack */

class Node
{
 public:
  unsigned data;
  Node* next;
};

class Stack
{
 private:
  Node* top;

 public:
  Stack() : top(nullptr) {}

  unsigned pop()
  {
    /* total definition / error flagging */
    // if (empty())
    // {
    //   return -1;
    // }

    /* fatal failure */
    // if (empty())
    // {
    //   std::cout << "FAILURE!!!\n";
    //   exit(-1);
    // }

    /* pre condition */
    // assert(!empty());

    /* Exception */
    if (empty())
    {
      // throw 0;
      // throw "Can't pop an empty stack\n";
      throw EmptyStackException("Can't pop an empty stack\n");
    }

    unsigned res = top->data;
    Node* newTop = top->next;
    delete top;
    top = newTop;
    return res;
  }

  void push(unsigned n)
  {
    Node* newTop = new Node();
    newTop->data = n;
    newTop->next = top;
    top = newTop;
  }

  bool empty() { return top == nullptr; }

  ~Stack()
  {
    while (top)
    {
      Node* next = top->next;
      delete top;
      top = next;
    }
  }
};

int main()
{
  // Stack stack = Stack();
  // stack.push(5);

  /* segfault */
  // std::cout << "Popping... " << stack.pop() << "\n";

  /* guard */
  // if (!stack.empty())
  // {
  //   std::cout << "Popping... " << stack.pop() << "\n";
  // }

  /* total definition */
  // std::cout << "Popping... " << stack.pop() << "\n";

  /* error flagging */
  // stack.push(5);
  // unsigned res = stack.pop();
  // if (res != -1)
  // {
  //   std::cout << "Popping... " << res << "\n";
  // }
  // else
  // {
  //   std::cout << "Can't pop an empty stack\n";
  // }

  /* fatal failure / pre condition */
  // stack.push(5);
  // std::cout << "Popping... " << stack.pop() << "\n";

  /* Exception */
  try
  {
    Stack stack = Stack();
    // stack.push(5);
    std::cout << "Popping... " << stack.pop() << "\n";
  }
  /* no finally */
  // try
  // {
  //   Stack* stack = new Stack();
  //   // stack->push(5);
  //   std::cout << "Popping... " << stack->pop() << "\n";
  //   std::cout << "Now destroying stack...\n";
  //   delete stack;
  // }

  /* RAII + smart pointer avoids memory leak when exception is thrown */
  // try
  // {
  //   std::unique_ptr<Stack> stack(new Stack());
  //   // stack->push(5);
  //   std::cout << "Popping... " << stack->pop() << "\n";
  // }
  catch (int i)
  {
    std::cout << "Can't pop an empty stack\n";
  }
  catch (const char* c)
  {
    std::cout << c;
  }
  catch(EmptyStackException e)
  {
     std::cout << e.what();
  }
  return 0;
}
