#ifndef CLASSIFICAARESTAS_H_
#define CLASSIFICAARESTAS_H_
#include "listaadj/autoreferencia/Grafo.h" // @{\it vide Programa~\ref{c_7.4}}@
#include <iostream>
using std::cout;
using std::endl;
using cap7_listaadj_autoreferencia::Grafo; // @{\it vide Programa~\ref{c_7.4}@
namespace cap7 {
	class ClassificaArestas {
  public: 
    static const unsigned char branco;
    static const unsigned char cinza;
    static const unsigned char preto;
  private: 
    int *d, *t, *antecessor;
    Grafo *grafo;
    int visitaDfs (int u, int tempo, unsigned char *cor) const;
  public:
	  ClassificaArestas (Grafo *grafo);
	  void classificaArestas () const;
	  int _d (int v) const;
	  int _t (int v) const;
	  int _antecessor (int v) const;
	  ~ClassificaArestas ();
	};
	const unsigned char ClassificaArestas::branco = 0;
	const unsigned char ClassificaArestas::cinza  = 1;
	const unsigned char ClassificaArestas::preto  = 2;
  int ClassificaArestas::visitaDfs (int u, int tempo, unsigned char *cor) const {
    cor[u] = cinza; this->d[u] = ++tempo;
//    cout << "Visita " << u << " Descoberta:" << this->d[u] << " cinza" << endl;
    if (!this->grafo->listaAdjVazia (u)) {
      Grafo::Aresta *a = this->grafo->primeiroListaAdj (u);
      while (a != NULL) {
        int v = a->_v2 ();
        if (cor[v] == branco) {
        	cout << "Arvore: " <<u<< "->" <<v<< " (branco)" << endl;
          this->antecessor[v] = u;
          tempo = this->visitaDfs (v, tempo, cor);
        }
        else if (cor[v] == cinza) {
          cout << "Retorno: " <<u<< "->" <<v<< " (cinza)" << endl;
        } else if (this->d[u] > this->d[v]) {
          cout << "Cruzamento: " <<u<< "->" <<v<< " (preto)" << endl;
        } else cout << "Avanco: " <<u<< "->" <<v<<" (preto)" << endl;
        delete a; a = this->grafo->proxAdj (u);
      }
    }
    cor[u] = preto; this->t[u] = ++tempo;
//    cout << "Visita " << u << " Termino:" << this->t[u] << " preto" << endl;
    return tempo;
  }
  ClassificaArestas::ClassificaArestas (Grafo *grafo) {
    this->grafo = grafo; 
    int n = this->grafo->_numVertices ();
    d = new int[n]; t = new int[n]; antecessor = new int[n];
  }
  void ClassificaArestas::classificaArestas () const {
    int tempo = 0; 
    unsigned char *cor = new unsigned char[this->grafo->_numVertices ()]; 
    for (int u = 0; u < grafo->_numVertices (); u++) {
      cor[u] = branco; this->antecessor[u] = -1;
    }     
    for (int u = 0; u < grafo->_numVertices (); u++)
      if (cor[u] == branco) {
      	cout << "Raiz da arvore: " << u << " (branco)" << endl;
      	tempo = this->visitaDfs (u, tempo, cor);
      }
    delete [] cor;
  }
  int ClassificaArestas::_d (int v) const { return this->d[v]; }
  int ClassificaArestas::_t (int v) const { return this->t[v]; }
  int ClassificaArestas::_antecessor (int v) const { 
  	return this->antecessor[v]; 
  }
  ClassificaArestas::~ClassificaArestas () {
    this->grafo = NULL; delete [] this->d;
    delete [] this->t; delete [] this->antecessor;
  }  
}

#endif
