#ifndef MEUITEM_H_
#define MEUITEM_H_
#include "Item.h" // @{\it vide Programa~\ref{c_4.0}}@ 
namespace cap4 {
	class MeuItem : public Item<int> {
	private:
	  int chave; 
	public: 
	  MeuItem (int chave);
	  virtual int compara (const Item<int> *item) const;
	  virtual void alteraChave (int chave);
	  virtual int recuperaChave () const;
	  virtual string toString () const;
	  void gravaArq (FILE * arq) const;
	  void leArq (FILE * arq);
	  static int tamanho ();  
	  ~MeuItem () {}
	};
	string MeuItem::toString () const {
		char valorStr[33];
		std::sprintf (valorStr, "%d", this->chave); string str (valorStr);
		return str;
	}
	MeuItem::MeuItem (int chave) { this->chave = chave; }
	int MeuItem::compara (const Item<int> *item) const {
	  MeuItem *it = (MeuItem *)item; 	
	  if (this->chave < it->chave) return -1;
	  else if (this->chave > it->chave) return 1;
	  return 0;
	}
	void MeuItem::alteraChave (int chave) { this->chave = chave; }
	int MeuItem::recuperaChave () const { return this->chave; }
	void MeuItem::gravaArq (FILE * arq) const {
		fwrite (&(this->chave), sizeof (int), 1, arq); 
	}
	void MeuItem::leArq (FILE * arq) { 
		fread (&(this->chave), sizeof (int), 1, arq); 
	}
	int MeuItem::tamanho () { return 4; /* @{\it 4 bytes}@ */ }
}
#endif
