#ifndef TESTAFPHEAPMAX_H_
#define TESTAFPHEAPMAX_H_
#include "ordenacaointerna/FPHeapMax.h"
#include "Item.h" // @{\it vide Programa~\ref{c_4.0}}@
#include "MeuItem.h"
#include<iostream>
using std::cin;
using std::cout;
using std::endl;
using cap4_ordenacaointerna::FPHeapMax;
namespace cap4 {
	class TestaFPHeapMax {
	private:
	  static void help (char *nomePrograma);
	public:
	  static void main (int argc, char **argv);
	};
	
	void TestaFPHeapMax::help (char *nomePrograma) {
	  cout << "Uso: " << nomePrograma << " <numero de elementos>" << endl;
	  exit (0);
	}
	
	void TestaFPHeapMax::main (int argc, char **argv) {
	  FPHeapMax A (20);
	  int aux, n;
	  if (argc != 2) help (argv[0]);
	  n = atoi (argv[1]);
	  Item<int> *V[n + 1];
	  try {
	    for (int i = 1; i <= n; i++) {
	    	cin >> aux;
	      V[i] = new MeuItem (aux);
	    }
	    // @{\it Teste: 20 15 18 10 12 9 13}@
	    A.copia (V, n);
	    cout << "Desordenado: ";
	    A.imprime ();
	    cout << "Constroi   : ";
	    A.constroi ();
	    A.imprime ();
	    Item<int> *x = new MeuItem (13);
	    cout << "Insere " + x->toString () + ": ";
	    A.insere (x);
	    A.imprime ();
	    x = A.max ();
	    cout << "Max:" + x->toString () << endl;
	    x = A.retiraMax ();
	    cout << "Retira" + x->toString () + ": ";
	    A.imprime ();
	    delete x;
	  } catch (logic_error e) {
	    cout << e.what () << endl;  	
	  }
	}
}
#endif 
