#ifndef TESTAORDENACAO_H_
#define TESTAORDENACAO_H_
#include "ordenacaointerna/Ordenacao.h"
#include "PermutacaoRandomica.h"
#include<iostream>
using std::cout;
using std::endl;
using cap4_ordenacaointerna::Ordenacao;
namespace cap4 {
	class TestaOrdenacao {
	private:
	  static void imprime (Item<int> **v, int n);
	  static void copia (Item<int> **fonte, Item<int> **destino, int n);
	  static void testa (Item<int> **v, int n);
	public:
	  static void main ();
	};
	
	void TestaOrdenacao::imprime (Item<int> **v, int n) {
	  for (int i = 1; i <= n; i++)
	    cout << v[i]->toString () << " ";
	  cout << endl;
	}
	
	void TestaOrdenacao::copia (Item<int> **fonte, Item<int> **destino, int n) {
	  for (int i = 1; i <= n; i++) destino[i] = fonte[i];
	}
	
	void TestaOrdenacao::testa (Item<int> **v, int n) {
	  for (int i = 2; i <= n; i++) {
	    if (v[i]->compara (v[i - 1]) < 0) {
	      cout << "ERRO: ";
	      imprime (v, n);
	      return;
	    }
	  }
	  cout << "OK: ";
	    imprime (v, n);
	}
	
	void TestaOrdenacao::main () {
	  int tam = 20;
	  Item<int> *a[tam + 1];
	  Item<int> *b[tam + 1 ];
	  int n = 20; /* Tamanho do arranjo a ser ordenado */
	  for (int i = 1; i <= n; i++)
	    a[i] = new MeuItem (i);          
	  PermutacaoRandomica::permut (a, n);
	  copia (a, b, n);
	  cout << "Desordenado : ";
	  imprime (a, n);
	  cout << "Selecao   ";
	  Ordenacao<int>::selecao (b, n);
	  testa (b, n);
	  copia (a, b, n);
	  cout << "Insercao  ";
	  Ordenacao<int>::insercao (b, n);
	  testa (b, n);
	  copia (a, b, n);
	  cout << "Shellsort ";
	  Ordenacao<int>::shellsort (b, n);
	  testa (b, n);
	  copia (a, b, n);
	  cout << "Quicksort ";
	  Ordenacao<int>::quicksort (b, n);
	  testa (b, n);
	  copia (a, b, n);
	  cout << "Heapsort  ";
	  Ordenacao<int>::heapsort (b, n);
	  testa (b, n);
	  copia (a, b, n);
	  cout << "BuscaBin  ";
	  Ordenacao<int>::ordenaPorInsercaoComBuscaBinaria (b, n);
	  testa (b, n);
	  for (int i = 1; i <= n; i++)
	    delete a[i];
	  
	}
}
#endif 
