#ifndef ORDENACAO_H_
#define ORDENACAO_H_
#include "../Item.h" // @{\it vide Programa~\ref{c_4.0}}@
#include "FPHeapMax.h" // @{\it vide Programa~\ref{c_4.80}}@
using namespace cap4;
namespace cap4_ordenacaointerna {
	template <class TipoChave> class Ordenacao {	
	private: 
	  typedef struct LimiteParticoes { int i, j; } LimiteParticoes;		
	  static LimiteParticoes particao (Item<TipoChave> **v, int esq, int dir);
	  static void ordena (Item<TipoChave> **v, int esq, int dir);
	public:
	  static void selecao (Item<TipoChave> **v, int n);
	  static void insercao (Item<TipoChave> **v, int n);
	  static void ordenaPorInsercaoComBuscaBinaria (Item<TipoChave> **v, int n);
	  static void shellsort (Item<TipoChave> **v, int n);	
	  static void quicksort (Item<TipoChave> **v, int n);
	  static void heapsort (Item<TipoChave> **v, int n);
	};
	
	template <class TipoChave>
	typename Ordenacao<TipoChave>::LimiteParticoes 
	Ordenacao<TipoChave>::particao (Item<TipoChave> **v, int esq, int dir) {
	  LimiteParticoes p; p.i = esq; p.j = dir;
	  Item<TipoChave> *x = v[(p.i + p.j) / 2]; // @{\it obt\'em o pivo x}@
	  do {
	    while (x->compara (v[p.i]) > 0) p.i++;
	    while (x->compara (v[p.j]) < 0) p.j--;
	    if (p.i <= p.j) {
	      Item<TipoChave> *w = v[p.i]; v[p.i] = v[p.j]; v[p.j] = w;
	      p.i++; p.j--;
	    }
	  } while (p.i <= p.j);
	  return p;
	}
	
	template <class TipoChave>
	void Ordenacao<TipoChave>::ordena (Item<TipoChave> **v,int esq,int dir) {
	  LimiteParticoes p = particao (v, esq, dir);
	  if (esq < p.j) ordena (v, esq, p.j);
	  if (p.i < dir) ordena (v, p.i, dir);
	}
	
	template <class TipoChave>
	void Ordenacao<TipoChave>::selecao (Item<TipoChave> **v, int n) {
	  for (int i = 1; i <= n - 1; i++) {
	    int min = i;
	    for (int j = i + 1; j <= n; j++) 
	      if (v[j]->compara (v[min]) < 0) min = j;
	    Item<TipoChave> *x = v[min]; v[min] = v[i]; v[i] = x;
	  }
	}
	
	template <class TipoChave>
	void Ordenacao<TipoChave>::insercao (Item<TipoChave> **v, int n) {
	  int j;
	  for (int i = 2; i <= n; i++) {
	    Item<TipoChave> *x = v[i]; j = i - 1;
	    v[0] = x; // @{\it sentinela}@
	    while (x->compara (v[j]) < 0) { v[j + 1] = v[j]; j--; }
	    v[j + 1] = x;
	  }
	}
	
	template <class TipoChave>
	void Ordenacao<TipoChave>::ordenaPorInsercaoComBuscaBinaria (Item<TipoChave> **v, int n) {
	  for (int i = 2; i <= n; i++) {
	    int meio, ind;
	    Item<TipoChave> *x = v[i];
	    int esq = 1;
	    int dir = i - 1;
	    do {
	      meio = (esq + dir) / 2;
	      int comparacao = x->compara (v[meio]);
	      if (comparacao == 0) break;
	      if (comparacao > 0) esq = meio + 1;
	      else dir = meio - 1;
	    } while (esq <= dir);
	    if (meio > esq) ind = meio;
	    else ind = esq;
	    for (int j = i; j >= ind + 1; j--) v[j] = v[j - 1];
	    v[ind] = x;
	  }
	}
	
	template <class TipoChave>
	void Ordenacao<TipoChave>::shellsort (Item<TipoChave> **v, int n) {
	  int h = 1;
	  do h = h * 3 + 1; while (h < n);
	  do {
	    h /= 3;
	    for (int i = h + 1; i <= n; i++) {
	      Item<TipoChave> *x = v[i]; int j = i;
	      while (v[j - h]->compara (x) > 0) {
	        v[j] = v[j - h]; j -= h;
	        if (j <= h) break;
	      }
	      v[j] = x;
	    }
	  } while (h != 1);
	}
	
	template <class TipoChave>
	void Ordenacao<TipoChave>::quicksort (Item<TipoChave> **v, int n) {
	  ordena (v, 1, n);
	}
	
	template <class TipoChave>
	void Ordenacao<TipoChave>::heapsort (Item<TipoChave> **v, int n) {
	  FPHeapMax fpHeap (v, n);
	  int dir = n;
	  fpHeap.constroi (); // @{\it constroi o heap}@
	  while (dir > 1) { // @{\it ordena o vetor}@ 
	    Item<TipoChave> *x = v[1]; v[1] = v[dir]; v[dir] = x;
	    dir--; fpHeap.refaz (1, dir);
	  }
	}  
}
#endif 
