#ifndef TESTAFPHEAPMIN_H_
#define TESTAFPHEAPMIN_H_
#include "ordenacaointerna/FPHeapMin.h"
#include "Item.h" // @{\it vide Programa~\ref{c_4.0}}@
#include "MeuItem.h"
#include<iostream>
using std::cin;
using std::cout;
using std::endl;
using cap4_ordenacaointerna::FPHeapMin;
namespace cap4 {
	class TestaFPHeapMin {
	private:
	  static void help (char *nomePrograma);
	public:
	  static void main (int argc, char **argv);
	};
	
	void TestaFPHeapMin::help (char *nomePrograma) {
	  cout << "Uso: " << nomePrograma << " <numero de elementos>" << endl;
	  exit (0);
	}
	
	void TestaFPHeapMin::main (int argc, char **argv) {
	  FPHeapMin A (20);
	  int aux, n;
	  if (argc != 2) help (argv[0]);
	  n = atoi (argv[1]);
	  Item<int> *V[n + 1];
	  try {
	    for (int i = 1; i <= n; i++) {
	    	cin >> aux;
	      V[i] = new MeuItem (aux);
	    }
	    // @{\it Teste: 20 15 18 10 12 9 13}@
	    A.copia (V, n);
	    cout << "Desordenado: ";
	    A.imprime ();
	    cout << "Constroi   : ";
	    A.constroi ();
	    A.imprime ();
	    cout << "Diminui chave posicao i=6 para 5: ";
	    A.diminuiChave (6, 5);
	    A.imprime ();    
	    Item<int> *x = new MeuItem (6);
	    cout << "Insere " + x->toString () + ": ";
	    A.insere (x);
	    A.imprime ();
	    x = A.min ();
	    cout << "Min:" + x->toString () << endl;
	    x = A.retiraMin ();
	    cout << "Retira " + x->toString () + ": ";
	    A.imprime ();
	    delete x;
	  } catch (logic_error e) {
	    cout << e.what () << endl;  	
	  }
	}
}
#endif 
