#ifndef PERMUTACAORANDOMICA_H_
#define PERMUTACAORANDOMICA_H_
#include "Item.h" // @{\it vide Programa~\ref{c_4.0}}@
#include "MeuItem.h" // @{\it vide Programa~\ref{c_4.1}}@
#include <stdlib.h>
#include <sys/time.h>
#include<iostream>
using std::cout;
using std::endl;
namespace cap4 {
	class PermutacaoRandomica {
	private:
	  static double rand0a1 ();
	public:
    static void permut (Item<int> **v, int n);
    static void permut (int *v, int n);
    static void permut (char *v, int n);
	  static void main ();
	};
	double PermutacaoRandomica::rand0a1 () {
		struct timeval semente;
		// @{\it utilizar o tempo como semente para a fun\c{c}\~ao srand ()}@
	  gettimeofday (&semente,NULL); 
	  srand ((int)(semente.tv_sec + semente.tv_usec));
	  double resultado = (double) rand ()/ RAND_MAX; 
	  return resultado;
	}
	void PermutacaoRandomica::permut (Item<int> **v, int n) {
	  for (int i = n - 1; i > 0; i--) {
	    int j = (int) (i * rand0a1 () + 1.0);
	    Item<int> *b = v[i]; v[i] = v[j]; v[j] = b;
	  }
	}
  void PermutacaoRandomica::permut (int *v, int n) {
    for (int i = n - 1; i > 0; i--) {
      int j = (int) (i * rand0a1 () + 1.0);
      int b = v[i]; v[i] = v[j]; v[j] = b;
    }
  }
  void PermutacaoRandomica::permut (char *v, int n) {
    for (int i = n - 1; i > 0; i--) {
      int j = (int) (i * rand0a1 () + 1.0);
      char b = v[i]; v[i] = v[j]; v[j] = b;
    }
  }
  
	void PermutacaoRandomica::main () {
	  int tam = 20, n = 20;
	  Item<int> *v[tam + 1];
	  for (int i = 1; i <= n; i++) v[i] = new MeuItem (i);
	  permut (v, n);
	  for (int i = 1; i <= n; i++) cout << v[i]->toString () + " ";
	  cout << endl;
	  for (int i = 1; i <= n; i++) delete v[i];
	}
}
#endif 
