#ifndef FPHEAPMAX_H_
#define FPHEAPMAX_H_
#include "../Item.h" // @{\it vide Programa~\ref{c_4.0}}@
#include <stdexcept> 
using std::logic_error;
#include <limits.h> 
#include<iostream>
using std::cout;
using std::endl;
using namespace cap4;
namespace cap4_ordenacaointerna {
	class FPHeapMax {
	private:
		Item<int> **v;
		int maxTam, n;
		bool destruir;  	
	public:
	  FPHeapMax (int maxTam); // @{\it Cria uma fila de prioridades vazia}@
	  FPHeapMax (Item<int> **v, int n); // @{\it Cria uma fila de prioridades vazia}@
	  void refaz (int esq, int dir);
	  void constroi ();
	  Item<int> *max () const;
	  Item<int> *retiraMax () throw ( logic_error );
	  void aumentaChave (int i, int chaveNova);
	  void insere (Item<int> *x) throw ( logic_error );
	  void imprime () const;
	  void copia (Item<int> **v, int n);
	  ~FPHeapMax ();
	};
	
	FPHeapMax::FPHeapMax (int maxTam) { 
	  this->v = new Item<int>*[maxTam + 1];
	  this->maxTam = maxTam;
	  this->n = 0;
	  this->destruir = true;
	}
	
	FPHeapMax::FPHeapMax (Item<int> **v, int n) { 
	  this->v = v;
	  this->maxTam = 0;
	  this->n = n;
	  this->destruir = false;
	}
	
	void FPHeapMax::refaz (int esq, int dir) {
	  int j = esq * 2;
	  Item<int> *x = this->v[esq];
	  while (j <= dir) {
	    if ((j < dir) && (this->v[j]->compara (this->v[j + 1]) < 0)) j++;
	    if (x->compara (this->v[j]) >= 0) break;
	    this->v[esq] = this->v[j];
	    esq = j; j = esq * 2;
	  }
	  this->v[esq] = x;
	}
	
	void FPHeapMax::constroi () {
	  int esq = n / 2 + 1;
	  while (esq > 1) {
	    esq--; this->refaz (esq, this->n);
	  }
	}
	
	Item<int>* FPHeapMax::max () const { return this->v[1]; }
	
	Item<int>* FPHeapMax::retiraMax () throw ( logic_error ) {
	  Item<int> *maximo;
	  if (this->n < 1) throw logic_error ("Erro: heap vazio");
	  else {
	    maximo = this->v[1];
	    this->v[1] = this->v[this->n--];
	    this->v[this->n + 1] = 0; // @{\it transfere a posse da mem\'oria}@
	    refaz (1, this->n);
	  } return maximo;
	}
	
	void FPHeapMax::aumentaChave (int i, int chaveNova) {
	  Item<int> *x = this->v[i];
	  x->alteraChave (chaveNova);
	  while ((i > 1) && (x->compara (this->v[i / 2]) >= 0)) {
	    this->v[i] = this->v[i / 2]; i /= 2;
	  } this->v[i] = x;
	}
	
	void FPHeapMax::insere (Item<int> *x) throw ( logic_error ) {
	  this->n++;
	  if (this->n == this->maxTam) throw logic_error ("Erro: heap cheio");
	  int chaveNova = x->recuperaChave ();
	  this->v[this->n] = x;
	  this->v[this->n]->alteraChave (INT_MIN); // @$-\infty$@
	  this->aumentaChave (this->n, chaveNova);
	}
	
	void FPHeapMax::imprime () const {
	  for (int i = 1; i <= this->n; i++)
	    cout << this->v[i]->toString () << " ";
	  cout << endl;
	}
	
	void FPHeapMax::copia (Item<int> **v, int n) {
	  for (int i = 1; i <= n; i++)
	    this->v[++(this->n)] = v[i];
	}
	
	FPHeapMax::~FPHeapMax () {
		if (this->destruir) {	  		
	    for (int i = 1; i <= n; i++)
	      if (this->v[i]) delete this->v[i];
	    delete this->v;
		}
	}
}
#endif
