#ifndef POLIMORFISMO_H_
#define POLIMORFISMO_H_
#include<iostream>
using std::cout;
using std::endl;
namespace cap1 {
	class Empregado {
	protected: 
	  float salario;
	public:
	  virtual float salarioMensal ();
	  virtual void imprime ();
	  virtual ~Empregado () {}
	};
	float Empregado::salarioMensal () { return salario; }
	void Empregado::imprime () { cout << "Empregado" << endl; }
		
	class Secretaria : public Empregado {
	private:
	  int velocidadeDeDigitacao;
	public:
	  void imprime ();
	};
	void Secretaria::imprime () { cout << "Secretaria" << endl; }
		
	class Gerente : public Empregado {
	private:
	  float bonus;
	public:
	  float salarioMensal ();
	  float salarioMensal (float desconto);
	  void imprime ();
	};
	float Gerente::salarioMensal () { return salario + bonus; }
	float Gerente::salarioMensal (float desconto) { 
	  return salario + bonus - desconto; 
	}
	void Gerente::imprime () { cout << "Gerente" << endl; }
		
	class Polimorfismo {
	public:
	  static void main ();
	};
	void Polimorfismo::main () {
	  Empregado *empregado = new Empregado ();
	  Empregado *secretaria = new Secretaria ();
	  Empregado *gerente = new Gerente ();
	  empregado->imprime (); secretaria->imprime (); gerente->imprime ();
	  delete empregado; delete secretaria; delete gerente;
	}	
}
#endif
