#ifndef PASSEIOCAVALO_H_
#define PASSEIOCAVALO_H_
#include<iostream>
using std::cout;
using std::endl;
namespace cap2 {
  class PasseioCavalo {
  private:
    int n; // @{\it Tamanho do lado do tabuleiro}@
    int *a, *b, **t;    
  public:
    PasseioCavalo (int n);
    bool tenta (int i, int x, int y);
    void imprimePasseio () const;
    static void main ();
    ~PasseioCavalo ();
  };
  PasseioCavalo::PasseioCavalo (int n) {
    this->n = n; this->t = new int*[n];
    for (int i = 0; i < n; i++)  this->t[i] = new int[n];
    this->a = new int[n]; this->b = new int[n];
    a[0] = 2;  a[1] = 1;  a[2] =-1; a[3] =-2;
    b[0] = 1;  b[1] = 2;  b[2] = 2; b[3] = 1;
    a[4] = -2; a[5] = -1; a[6] = 1; a[7] = 2;
    b[4] = -1; b[5] = -2; b[6] =-2; b[7] = -1;
    for (int i = 0; i < n; i++) for (int j = 0; j < n; j++) t[i][j] = 0;
    t[0][0] = 1; // @{\it escolhemos uma casa do tabuleiro}@ 
  }
  PasseioCavalo::~PasseioCavalo () {
    delete []a; delete []b; 
    for (int i = 0; i < n; i++)  delete []this->t[i];
    delete []this->t;
  }
  bool PasseioCavalo::tenta (int i, int x, int y) {
    int u, v, k; bool q;
    k = -1;  // @{\it inicializa sele\c{c}\~ao de movimentos}@
    do {
      k = k + 1; q = false;
      u = x + a[k]; v = y + b[k];
      // @{\it Teste para verificar se os limites do tabuleiro}@
      // @{\it ser\~ao respeitados}@
      if ((u >= 0) && (u <= 7) && (v >= 0) && (v <= 7)) 
        if (t[u][v] == 0) {
          t[u][v] = i;
          if (i < n * n) { // @{\it tabuleiro n\~ao est\'a cheio}@
            q = tenta (i+1, u, v); // @{\it tenta novo movimento}@
            if (!q) t[u][v] = 0; // @{\it n\~ao sucedido apaga reg. anterior}@ 
          }
          else q = true;
        }
    } while (!q && (k != 7)); // @{\it n\~ao h\'a casas \`a visitar a partir de x,y}@
    return q;
  }
  void PasseioCavalo::imprimePasseio () const {
    for (int i = 0; i < n; i++) { 
      for (int j = 0; j < n; j++) cout << "\t"  << this->t[i][j];
      cout << endl;
    }
  }  
  void PasseioCavalo::main () {
    PasseioCavalo passeioCavalo (8);
    bool q = passeioCavalo.tenta (2, 0, 0);
    if (q) passeioCavalo.imprimePasseio();
    else cout << "Sem solucao" << endl;
  }
}
#endif
