#ifndef FILA_H_
#define FILA_H_
#include <stdexcept> 
using std::logic_error;
#include<iostream>
using std::cout;
using std::endl;
namespace cap3_arranjo {
  // @{\it Para utilizar a classe Fila<T> o tipo de dado fornecido no}@ 
  // @{\it lugar do par\^ametro de tipo T deve possuir um construtor de}@ 
  // @{\it c\'opia e os operadores << e = sobrecarregados.}@
	template <class T> class Fila {
	private:
	  T   **item;
	  int frente, tras, maxTam; 
	public:
		Fila (); // @{\it Cria uma Fila vazia}@
		Fila (int maxTam); // @{\it Cria uma Fila vazia}@
		void enfileira (const T& x) throw ( logic_error );
		T *desenfileira () throw ( logic_error );
		bool vazia () const;
		void imprime () const;
		~Fila ();
	};		
	template <class T> Fila<T>::Fila () {
	  this->item = new T*[1000]; this->maxTam = 1000; this->frente = 0; 
	  this->tras = this->frente;
	}	
	template <class T> Fila<T>::Fila (int maxTam) {
		this->item = new T*[maxTam]; this->maxTam = maxTam; this->frente = 0;
	  this->tras = this->frente;
	}	
	template <class T>	
	void Fila<T>::enfileira (const T& x) throw ( logic_error ) {  
	  if ((this->tras + 1) % this->maxTam == this->frente)
	    throw logic_error ("Erro: A fila esta cheia");
	  this->item[this->tras] = new T (x);
	  this->tras = (this->tras + 1) % this->maxTam; 
	}	
	template <class T> T *Fila<T>::desenfileira () throw ( logic_error ) {
	  if (this->vazia ()) throw logic_error ("Erro: A fila esta vazia");
	  T *item = this->item[this->frente];
	  this->item[this->frente] = 0; // @{\it transfere a posse da mem\'oria}@
	  this->frente = (this->frente + 1) % this->maxTam;
	  return item;
	}		
	template <class T> bool Fila<T>::vazia () const {
		return (this->frente == this->tras);
	}	
	template <class T> void Fila<T>::imprime () const {
	  for (int i = this->frente; i != this->tras; i = (i + 1)%this->maxTam)
	    cout << *(this->item[i]) << endl;
	}	  
	template <class T> Fila<T>::~Fila () {
	  for (int i = this->frente; i != this->tras; i = (i + 1)%this->maxTam)
	    delete item[i];
		delete[] item;
	}
}
#endif 
