#ifndef AREA_H_
#define AREA_H_
#include "../../cap4/Item.h" /*-- vide Programa@{\it ~\ref{c_4.0}@ --*/
#include <stdexcept> 
using std::logic_error;
#include<iostream>
using std::cout;
using std::endl;
using namespace cap4;
namespace cap3_arranjo {
	template <class TipoChave> class Area {
	private:
		class Celula {
		friend class Area<TipoChave>;
		private:
	  	Item<TipoChave> *item; int prox, ant;
	  	Celula () { item = 0;} ~Celula () { if (item != 0) delete item;}
		};
	  Celula *itens;
	  int  celulasDisp, primeiro, ultimo, numCelOcupadas, maxTam;     
	public:
		Area (); // Cria uma Area vazia
		Area (int maxTam); // Cria uma Area vazia
	  int obterNumCelOcupadas () const;
	  void insereItens (Item<TipoChave> *item) throw ( logic_error );
		Item<TipoChave> *retiraPrimeiro () throw ( logic_error );
		Item<TipoChave> *retiraUltimo () throw ( logic_error );
		void imprimeArea () const throw ( logic_error );
		~Area ();
	};	
	
	template <class TipoChave>
	Area<TipoChave>::Area () { // Cria uma Area vazia
	  itens = new Celula[1000];
	  this->maxTam = 1000; this->numCelOcupadas = 0;
	  this->primeiro = -1; this->ultimo = -1;
	  this->celulasDisp = 0;
	  for (int i = 0; i < this->maxTam; i++) {
	    this->itens[i].ant = -1; this->itens[i].prox = i + 1;
	  }
	}	
	template <class TipoChave>
	Area<TipoChave>::Area (int maxTam) { // Cria uma Area vazia
	  itens = new Celula[maxTam];
	  this->maxTam = maxTam; this->numCelOcupadas = 0;
	  this->primeiro = -1; this->ultimo = -1;
	  this->celulasDisp = 0;
	  for (int i = 0; i < this->maxTam; i++) {
	    this->itens[i].ant = -1; this->itens[i].prox = i + 1;
	  }
	}	
	template <class TipoChave>	
	int Area<TipoChave>::obterNumCelOcupadas () const {
	  return this->numCelOcupadas;
	}	
	template <class TipoChave>	
	void Area<TipoChave>::insereItens (Item<TipoChave> *item) 
	throw ( logic_error ) {
		if (this->numCelOcupadas == this->maxTam)
	    throw logic_error ("Erro: Tentativa de insercao em Area cheia");
	  int disp = this->celulasDisp;
	  this->celulasDisp = this->itens[this->celulasDisp].prox;
	  this->itens[disp].item = item; this->numCelOcupadas++;
	  /* Insercao do primeiro item */
	  if (this->numCelOcupadas == 1) { 
	    this->primeiro = disp; this->ultimo = this->primeiro;
	    this->itens[this->primeiro].prox = -1;
	    this->itens[this->primeiro].ant = -1;
	    return;
	  }
	  int pos = this->primeiro;
	  /* Insercao realizada na primeira posicao */
	  if (item->compara (this->itens[pos].item) < 0) { 
	    this->itens[disp].ant = -1; this->itens[disp].prox = pos;
	    this->itens[pos].ant = disp; this->primeiro = disp;
	    return;
	  }
	  int indiceInsercao = this->itens[pos].prox;
	  while (indiceInsercao != -1 && 
	         this->itens[indiceInsercao].item->compara (item) < 0) {
	    pos = indiceInsercao; indiceInsercao = this->itens[pos].prox;
	  }
	  /* Insercao realizada na ultima posicao */
	  if (indiceInsercao == -1) { 
	    this->itens[disp].ant = pos;  this->itens[disp].prox = -1;
	    this->itens[pos].prox = disp; this->ultimo = disp;
	    return;
	  }
	  /* Insercao realizada no meio de Area */
	  this->itens[disp].ant = pos;
	  this->itens[disp].prox = this->itens[pos].prox;
	  this->itens[pos].prox = disp; pos = this->itens[disp].prox;
	  this->itens[pos].ant = disp;
	}	
	template <class TipoChave>
	Item<TipoChave> *Area<TipoChave>::retiraPrimeiro () 
	throw ( logic_error ) {
	  if (this->numCelOcupadas == 0) throw logic_error ("Erro: Area vazia");
	  Item<TipoChave> *item = this->itens[this->primeiro].item;
	  this->itens[this->primeiro].item = 0; // @{\it transfere a posse da mem\'oria}@
	  int proxTmp = this->itens[this->primeiro].prox;
	  this->itens[this->primeiro].prox = this->celulasDisp;
	  this->celulasDisp = this->primeiro; this->primeiro = proxTmp;
	  if ((this->primeiro >= 0) && (this->primeiro < this->maxTam))
	    this->itens[this->primeiro].ant = -1;
	  this->numCelOcupadas--;
	  return item;
	}		
	template <class TipoChave>
	Item<TipoChave> *Area<TipoChave>::retiraUltimo () 
	throw ( logic_error ) {
	  if (this->numCelOcupadas == 0) throw logic_error ("Erro: Area vazia");
	  Item<TipoChave> *item = this->itens[this->ultimo].item;
	  this->itens[this->ultimo].item = 0; // transfere a posse da memoria
	  int antTmp = this->itens[this->ultimo].ant;
	  this->itens[this->ultimo].prox = this->celulasDisp;
	  this->celulasDisp = this->ultimo; this->ultimo = antTmp;
	  if ((this->ultimo >= 0) && (this->ultimo < this->maxTam))
	    this->itens[this->ultimo].prox = -1;
	  this->numCelOcupadas--;
	  return item;
	}	
	template <class TipoChave>
	void Area<TipoChave>::imprimeArea () const throw ( logic_error ) {
	  if (this->numCelOcupadas == 0) throw logic_error ("Erro: Area vazia");
	  cout << "** LISTA **" << endl;
	  cout << "Celulas Ocupadas = " << this->numCelOcupadas << endl;
	  int pos = this->primeiro;
	  while (pos != -1) {
	    cout << this->itens[pos].item->toString () << endl;
	    pos = this->itens[pos].prox;
	  }
	}	
	template <class TipoChave>	
	Area<TipoChave>::~Area () {
		delete[] itens;
	}
}
#endif 
