#ifndef VESTIBULAR_H_
#define VESTIBULAR_H_
#include "autoreferencia/Lista.h" // @{\it vide Programa~\ref{c_3.3}}@
#include<iostream>
using std::cout;
using std::cin;
using std::endl;
using std::ostream;
#define nOpcoes 3
#define nCursos 7
using cap3_autoreferencia::Lista; // @{\it vide Programa~\ref{c_3.3}}@
namespace cap3 {
	class Registro {
		friend class Vestibular;
		friend ostream& operator<< (ostream& out, const Registro& registro);
	private:
	  short chave, notaFinal, opcao[nOpcoes];
	public:
	  bool operator== (const Registro& registro) const {
	  	return this->chave == registro.chave;
	  }
	};
	ostream& operator<< (ostream& out, const Registro& registro) {
		out << registro.chave;
		return out;
	}
	class Vestibular {
	private:
	  static Registro *leRegistro ();
	public:
	  static void main ();
	};
	Registro *Vestibular::leRegistro () {
	  // @{\it os valores lidos devem estar separados por brancos}@
	  Registro *registro = new Registro ();
	  cin >> registro->chave; cin >> registro->notaFinal;
	  for (int i = 0; i < nOpcoes; i++) cin >> registro->opcao[i];
	  return registro;
	}
	void Vestibular::main () {
	  Registro *registro = 0;
	  Lista<Registro> classificacao[11], aprovados[nCursos], reprovados;
	  long vagas[nCursos];
	  bool passou;
	  int i;
	  try {
	    for (i = 0; i < nCursos; i++) cin >> vagas[i];
	    registro = leRegistro ();
	    while (registro->chave != 0) {
	      classificacao[registro->notaFinal].insere (*registro);
	      delete registro; registro = leRegistro ();
	    }
	    delete registro;
	    for (int Nota = 10; Nota >= 0; Nota--) {
	      while (!classificacao[Nota].vazia ()) {
	        registro = classificacao[Nota].retiraPrimeiro ();
	        i = 0; passou = false;
	        while (i < nOpcoes && !passou) {
	          if (vagas[registro->opcao[i] - 1] > 0) {
	            aprovados[registro->opcao[i] - 1].insere (*registro);
	            vagas[registro->opcao[i] - 1]--; passou = true;
	          }
	          i++;
	        }
	        if (!passou) reprovados.insere (*registro);
	        delete registro;
	      }
	    }
	  } catch (logic_error e) { cout << e.what () << endl; }
	  for (i = 0; i < nCursos; i++) {
	    cout << "Relacao dos aprovados no Curso" << i + 1 << endl;
	    aprovados[i].imprime ();
	  }
	  cout << "Relacao dos reprovados" << endl;
	  reprovados.imprime ();
	}
}
#endif 
