#ifndef PILHA_H_
#define PILHA_H_
#include <stdexcept> 
using std::logic_error;
namespace cap3_arranjo {
  // @{\it Para utilizar a classe Pilha<T> o tipo de dado fornecido no}@
  // @{\it lugar do par\^ametro de tipo T deve possuir um construtor de}@
  // @{\it c\'opia e o operador = sobrecarregado.}@
	template <class T> class Pilha {
	private:
	  T   **item;
	  int topo, maxTam; 
	public:
		Pilha (); // @{\it Cria uma Pilha vazia}@
		Pilha (int maxTam); // @{\it Cria uma Pilha vazia}@
		void empilha (const T& x) throw ( logic_error );
		T *desempilha () throw ( logic_error );
		bool vazia () const;
		int tamanho () const;
		~Pilha ();
	};
	
	template <class T> Pilha<T>::Pilha () {
		this->item = new T*[1000]; this->topo = 0;	this->maxTam = 1000;
	}
	template <class T> Pilha<T>::Pilha (int maxTam) {
		this->item = new T*[maxTam];	this->topo = 0;	
		this->maxTam = maxTam;
	}	
	template <class T>	
	void Pilha<T>::empilha (const T& x) throw ( logic_error ) {
		if (this->topo == this->maxTam)
	    throw logic_error ("Erro: A pilha esta cheia");
	  else this->item[(this->topo)++] = new T (x);
	}	
	template <class T>	
	T *Pilha<T>::desempilha () throw ( logic_error ) {
	  if (this->vazia ()) throw logic_error ("Erro: A pilha esta vazia");
	  T *item = this->item[--(this->topo)];
	  this->item[this->topo] = 0; // @{\it transfere a posse da mem\'oria}@
	  return item;
	}		
	template <class T> bool Pilha<T>::vazia () const {
		return (this->topo == 0);
	}	
	template <class T> int Pilha<T>::tamanho () const {
		return this->topo;
	}	
	template <class T> Pilha<T>::~Pilha () {
		for (int i = 0; i < this->topo; i++) delete item[i];
		delete[] item;
	}
}
#endif 
