package cap3;
import java.io.*;
import cap3.autoreferencia.Lista; // @{\it vide Programa~\ref{Fig2.1.5}}@
public class Vestibular {
  private class Definicoes {
    public static final int nOpcoes = 3;
    public static final int nCursos = 7;
  }
  private static class Registro {
    short chave;
    byte  notaFinal;
    byte  opcao[] = new byte[Definicoes.nOpcoes];
    public String toString () { return new String ("" + this.chave); }
  }
  private static BufferedReader in = new BufferedReader (
                                     new InputStreamReader (System.in));
  static Registro leRegistro () throws IOException {
    // @{\it os valores lidos devem estar separados por brancos}@
    Registro registro = new Registro ();
    String str = in.readLine ();
    registro.chave = Short.parseShort (str.substring (0, 
                                       str.indexOf (" ")));
    registro.notaFinal = Byte.parseByte (str.substring (
                                         str.indexOf (" ") + 1));
    for (int i = 0; i < Definicoes.nOpcoes; i++)
      registro.opcao[i] = Byte.parseByte (in.readLine ());
    return registro;
  }
  public static void main (String[] args) {
    Registro registro = null;
    Lista classificacao[] = new Lista[11];
    Lista aprovados[] = new Lista[Definicoes.nCursos];
    Lista reprovados = new Lista ();
    long vagas[] = new long[Definicoes.nCursos];
    boolean passou;
    int i;
    try {
      for (i = 0; i < Definicoes.nCursos; i++)
        vagas[i] = Long.parseLong (in.readLine ());
      for (i = 0; i < 11; i++) classificacao[i] = new Lista ();
      for (i = 0; i < Definicoes.nCursos; i++)
        aprovados[i] = new Lista ();
      registro = leRegistro ();
      while (registro.chave != 0) {
        classificacao[registro.notaFinal].insere (registro);
        registro = leRegistro ();
      }
      for (int Nota = 10; Nota >= 0; Nota--) {
        while (!classificacao[Nota].vazia ()) {
          registro = (Registro) classificacao[Nota].retiraPrimeiro ();
          i = 0; passou = false;
          while (i < Definicoes.nOpcoes && !passou) {
            if (vagas[registro.opcao[i] - 1] > 0) {
              aprovados[registro.opcao[i] - 1].insere (registro);
              vagas[registro.opcao[i] - 1]--; passou = true;
            }
            i++;
          }
          if (!passou) reprovados.insere (registro);
        }
      }
    } catch (Exception e) { System.out.println (e.getMessage ()); }
    
    for (i = 0; i < Definicoes.nCursos; i++) {
      System.out.println ("Relacao dos aprovados no Curso" + (i + 1));
      aprovados[i].imprime ();
    }
    System.out.println ("Relacao dos reprovados");
    reprovados.imprime ();
  }
}