#ifndef TESTAORDENACAOPARCIAL_H_
#define TESTAORDENACAOPARCIAL_H_
#include "ordenacaointerna/OrdenacaoParcial.h"
#include "PermutacaoRandomica.h"
#include<iostream>
using std::cout;
using std::endl;
using std::cin;
using cap4_ordenacaointerna::OrdenacaoParcial;
namespace cap4 {
	class TestaOrdenacaoParcial {
	private:
	  static void imprime (Item<int> **v, int n);
	  static void copia (Item<int> **fonte, Item<int> **destino, int n);
	  static void testa (Item<int> **v, int n, int k);
	public:
	  static void main ();
	};
	
	void TestaOrdenacaoParcial::imprime (Item<int> **v, int n) {
	  for (int i = 1; i <= n; i++)
	    cout << v[i]->toString () << " ";
	  cout << endl;
	}
	
	void TestaOrdenacaoParcial::copia (Item<int> **fonte, Item<int> **destino, int n) {
	  for (int i = 1; i <= n; i++) destino[i] = fonte[i];
	}
	
	void TestaOrdenacaoParcial::testa (Item<int> **v, int n, int k) {
	  for (int i = 2; i <= k; i++) {
	    if (v[i]->compara (v[i - 1]) < 0) {
	      cout << "ERRO: ";
	      imprime (v, n);
	      return;
	    }
	  }
	  cout << "OK: ";
	  imprime (v, n);
	}
	
	void TestaOrdenacaoParcial::main () {
	  int tam = 20;
	  Item<int> *a[tam + 1];
	  Item<int> *b[tam + 1 ];
	  int n = 20, k = 0;
	  for (int i = 1; i <= n; i++)
	    a[i] = new MeuItem (i);          
	  PermutacaoRandomica::permut (a, n);
	  copia (a, b, n);
	  cout << "Desordenado : ";
	  imprime (a, n);
	  cout << "Valor de k = ";
	  cin >> k;
	  cout << "SelecaoParcial: " << endl;
	  OrdenacaoParcial<int>::selecaoParcial (b, n, k);
	  testa (b, n, k);
	  copia (a, b, n);
	  cout << "InsercaoParcial: " << endl;
	  OrdenacaoParcial<int>::insercaoParcial (b, n, k);
	  testa (b, n, k);
	  copia (a, b, n);
	  cout << "InsercaoParcial2: " << endl;
	  OrdenacaoParcial<int>::insercaoParcial2 (b, n, k);
	  testa (b, n, k);
	  copia (a, b, n);
	  cout << "QuicksortParcial: " << endl;
	  OrdenacaoParcial<int>::quicksortParcial (b, n, k);
	  testa (b, n, k);
	  copia (a, b, n);
	  cout << "HeapsortParcial: " << endl;
	  OrdenacaoParcial<int>::heapsortParcial (b, n, k);
	  cout << "A parte ordenada esta no final do vetor:" << endl;
	  imprime (b, n);
	  copia (a, b, n);
	  cout << "DavisortParcial: " << endl;
	  OrdenacaoParcial<int>::davisortParcial (b, n, k);
	  testa (b, n, k);
	  for (int i = 1; i <= n; i++)
	    delete a[i];
	}
}
#endif 
