#ifndef QUICKSORTEXTERNO_H_
#define QUICKSORTEXTERNO_H_
#include "../Item.h" // @{\it vide Programa~\ref{c_4.0}}@
#include "../MeuItem.h" // @{\it vide Programa~\ref{c_4.1}}@
#include "../../cap3/arranjo/Area.h" // @{\it vide Programa~\ref{c_3.23}}@
#include<stdio.h>
#include<limits.h>
#include <stdexcept> 
using std::logic_error;
using namespace cap4;
using cap3_arranjo::Area; // @{\it vide Programa~\ref{c_3.23}}@
namespace cap4_ordenacaoexterna {
	class QuicksortExterno {
	private: 
		typedef struct LimiteParticoes { int i, j; } LimiteParticoes;
    FILE  *arqLi, *arqEi, *arqLEs;
    bool  ondeLer;
	  Item<int> *ultLido;
	  Area<int> *area;  
		int tamArea;
    // @{\it M\'etodos utilizados pelo m\'etodo particao do quicksort externo}@
	  int leSup (int ls);	
	  int leInf (int li);	
	  int inserirArea () throw ( logic_error );
	  int escreveMax (int es);
	  int escreveMin (int ei) ;
	  int retiraMax () throw ( logic_error ) ;
	  int retiraMin () throw ( logic_error ) ;
	  LimiteParticoes particao (int esq, int dir) throw ( logic_error ); 
	public:
	  QuicksortExterno (char *nomeArq, int tamArea);    
	  void quicksortExterno (int esq, int dir) throw ( logic_error );	
	  void fechaArquivos ();
	  ~QuicksortExterno (){};		
	};
	
	int QuicksortExterno::leSup (int ls) {
		this->ultLido = new MeuItem (0); fflush (this->arqLEs);
		fseek (this->arqLEs, (ls - 1) * MeuItem::tamanho (), SEEK_SET);
		((MeuItem*)ultLido)->leArq (arqLEs); ondeLer = false;
	  return --ls;
	}
	int QuicksortExterno::leInf (int li) {
		this->ultLido = new MeuItem (0); fflush (this->arqLi);
	  ((MeuItem*)ultLido)->leArq (arqLi); ondeLer = true;
	  return ++li;
	}
	int QuicksortExterno::inserirArea () throw ( logic_error ) { 
	  area->insereItens (this->ultLido);
	  return area->obterNumCelOcupadas ();
	}
	int QuicksortExterno::escreveMax (int es) {
		fseek (this->arqLEs, (es - 1) * MeuItem::tamanho (), SEEK_SET );
		((MeuItem*)ultLido)->gravaArq (arqLEs);	
		delete this->ultLido;
	  return --es;
	}
	int QuicksortExterno::escreveMin (int ei) {
	  ((MeuItem*)ultLido)->gravaArq (arqEi); delete this->ultLido;
	  return ++ei;
	}
	int QuicksortExterno::retiraMax () throw ( logic_error ) {
	  this->ultLido = area->retiraUltimo ();
	  return area->obterNumCelOcupadas ();
	}
	int QuicksortExterno::retiraMin () throw ( logic_error ) {
	  this->ultLido = area->retiraPrimeiro ();
	  return area->obterNumCelOcupadas ();
	}
	QuicksortExterno::LimiteParticoes 
	QuicksortExterno::particao (int esq, int dir) throw ( logic_error ) {
	  int ls = dir, es = dir, li = esq, ei = esq, nrArea = 0;
	  Item<int> *linf = new MeuItem (INT_MIN);
	  Item<int> *lsup = new MeuItem (INT_MAX);
	  this->ondeLer = true;
	  LimiteParticoes p;
	  this->area = new Area<int> (this->tamArea);
	  fseek (this->arqLi, (li - 1)* MeuItem::tamanho (), SEEK_SET );
	  fseek (this->arqEi, (ei - 1)* MeuItem::tamanho (), SEEK_SET );	    
	  p.i = esq - 1; p.j = dir + 1;
	  while (ls >= li) {
	    if (nrArea < this->tamArea - 1) {
	      if (ondeLer) ls = this->leSup (ls); 
	      else li = leInf (li);
	      nrArea = inserirArea ();
	    }
	    else {
	      if (ls == es) ls = leSup (ls); 
	      else if (li == ei) li = leInf (li);
	      else if (ondeLer)  ls = leSup (ls);
	      else li = leInf (li);
	      if (ultLido->compara (lsup) > 0) {
	        p.j = es; es = escreveMax (es);
	      }
	      else if (ultLido->compara (linf) < 0) {
	        p.i = ei; ei = escreveMin (ei);
	      }
	      else {
	        nrArea = inserirArea ();
	        if (ei - esq < dir - es) {
	          nrArea = retiraMin ();
	          linf->alteraChave (this->ultLido->recuperaChave ());
	          ei = escreveMin (ei);
	        }
	        else {
	          nrArea = retiraMax ();
	          lsup->alteraChave (this->ultLido->recuperaChave ());
	          es = escreveMax (es);
	        }
	      }
	    }
	  }
	  while (ei <= es) { nrArea = retiraMin (); ei = escreveMin (ei); }
	  delete linf; delete lsup; delete area;
	  return p;
	}	
	QuicksortExterno::QuicksortExterno (char *nomeArq, int tamArea) {
	  this->arqLi   = fopen (nomeArq, "r+b");
	  this->arqEi   = fopen (nomeArq, "r+b");
	  this->arqLEs  = fopen (nomeArq, "r+b");
	  ultLido = 0; area = 0; this->tamArea = tamArea;
	}  
	void QuicksortExterno::
	quicksortExterno (int esq, int dir) throw ( logic_error ) {
	  if (dir - esq < 1) return;
	  LimiteParticoes p = particao (esq, dir);
	  if (p.i - esq < dir - p.j) { // @{\it ordene primeiro o subarquivo menor}@
	    quicksortExterno (esq, p.i); quicksortExterno (p.j, dir);
	  }
	  else { quicksortExterno (p.j, dir); quicksortExterno (esq, p.i); }
	}	
	void QuicksortExterno::fechaArquivos () {
	  fclose (this->arqEi);
	  fclose (this->arqLi);
	  fclose (this->arqLEs);
	}
}
#endif
