package cap3.arranjo;
import cap4.Item; // @{\it vide Programa~\ref{prog:interfaceitem}}@
public class Area {
  private static class Celula {
    Item item;
    int  prox, ant;
  }
  private Celula itens[];
  private int    celulasDisp, primeiro, ultimo;
  private int    numCelOcupadas;
  // @{\it Opera\c{c}\~oes}@
  public Area () { // @{\it Cria uma Area vazia}@
    itens = new Celula[1000];
    this.numCelOcupadas = 0;
    this.primeiro = -1;
    this.ultimo = -1;
    this.celulasDisp = 0;
    for (int i = 0; i < itens.length; i++) {
      this.itens[i] = new Celula ();
      this.itens[i].ant = -1;
      this.itens[i].prox = i + 1;
    }
  }
  public Area (int tamArea) { // @{\it Cria uma Area vazia}@
    itens = new Celula[tamArea]; this.numCelOcupadas = 0;
    this.primeiro = -1; this.ultimo = -1;
    this.celulasDisp = 0;
    for (int i = 0; i < itens.length; i++) {
      this.itens[i] = new Celula (); this.itens[i].ant = -1;
      this.itens[i].prox = i + 1;
    }
  }
  public int obterNumCelOcupadas () {
    return this.numCelOcupadas;
  }
  public void insereItem (Item item) throws Exception {
    if (this.numCelOcupadas == this.itens.length)
      throw new Exception ("Erro: Tentativa de insercao em Area cheia");
    int disp = this.celulasDisp;
    this.celulasDisp = this.itens[this.celulasDisp].prox;
    this.itens[disp].item = item; this.numCelOcupadas++;
    // @{\it Inser\c{c}\~ao do primeiro item}@ 
    if (this.numCelOcupadas == 1) { 
      this.primeiro = disp; this.ultimo = this.primeiro;
      this.itens[this.primeiro].prox = -1;
      this.itens[this.primeiro].ant = -1;
      return;
    }
    int pos = this.primeiro;
    // @{\it Inser\c{c}\~ao realizada na primeira posi\c{c}\~ao}@
    if (item.compara (this.itens[pos].item) < 0) { 
      this.itens[disp].ant = -1; this.itens[disp].prox = pos;
      this.itens[pos].ant = disp; this.primeiro = disp;
      return;
    }
    int indiceInsercao = this.itens[pos].prox;
    while (indiceInsercao != -1 && 
           this.itens[indiceInsercao].item.compara (item) < 0) {
      pos = indiceInsercao; indiceInsercao = this.itens[pos].prox;
    }
    // @{\it Inser\c{c}\~ao realizada na \'ultima posi\c{c}\~ao}@
    if (indiceInsercao == -1) { 
      this.itens[disp].ant = pos;  this.itens[disp].prox = -1;
      this.itens[pos].prox = disp; this.ultimo = disp;
      return;
    }
    // @{\it Inser\c{c}\~ao realizada no meio de Area}@
    this.itens[disp].ant = pos; 
    this.itens[disp].prox = this.itens[pos].prox;
    this.itens[pos].prox = disp; pos = this.itens[disp].prox;
    this.itens[pos].ant = disp;
  }
  public Item retiraPrimeiro () throws Exception {
    if (this.numCelOcupadas == 0)
      throw new Exception ("Erro: Area vazia");
    Item item = this.itens[this.primeiro].item;
    int proxTmp = this.itens[this.primeiro].prox;
    this.itens[this.primeiro].prox = this.celulasDisp;
    this.celulasDisp = this.primeiro;
    this.primeiro = proxTmp;
    if ((this.primeiro >= 0) && (this.primeiro < this.itens.length))
      this.itens[this.primeiro].ant = -1;
    this.numCelOcupadas--;
    return item;
  }
  public Item retiraUltimo () throws Exception {
    if (this.numCelOcupadas == 0)
      throw new Exception ("Erro: Area vazia");
    Item item = this.itens[this.ultimo].item;
    int antTmp = this.itens[this.ultimo].ant;
    this.itens[this.ultimo].prox = this.celulasDisp;
    this.celulasDisp = this.ultimo;
    this.ultimo = antTmp;
    if ((this.ultimo >= 0) && (this.ultimo < this.itens.length))
      this.itens[this.ultimo].prox = -1;
    this.numCelOcupadas--;
    return item;
  }
  public void imprimeArea () throws Exception {
    int pos;
    if (this.numCelOcupadas == 0)
      throw new Exception ("Erro: Area vazia");
    System.out.println ("** LISTA **");
    System.out.println ("Celulas Ocupadas = " + this.numCelOcupadas);
    pos = this.primeiro;
    while (pos != -1) {
      System.out.println (this.itens[pos].item.toString ());
      pos = this.itens[pos].prox;
    }
  }
}
