package cap4.ordenacaoexterna;

import cap3.arranjo.Area; // @{\it vide Programa~\ref{prog:tipoabstratoarea}}@
import cap4.MeuItem; // @{\it vide Programa~\ref{prog:tipoitem}}@
import java.io.*;

public class QuicksortExterno {
  private static class LimiteParticoes { int i; int j; }
  private RandomAccessFile arqLi;
  private RandomAccessFile arqEi;
  private RandomAccessFile arqLEs;
  private boolean          ondeLer;
  private MeuItem          ultLido;
  private Area             area;
  private int              tamArea;
  // @{\it M\'etodos utilizados pelo m\'etodo particao do quicksort externo}@
  private int leSup (int ls) throws IOException {
    this.ultLido = new MeuItem (0);
    arqLEs.seek ((ls - 1) * MeuItem.tamanho ());
    this.ultLido.leArq (arqLEs); ondeLer = false;
    return --ls;
  }

  private int leInf (int li) throws IOException {
    this.ultLido = new MeuItem (0);
    this.ultLido.leArq (arqLi); ondeLer = true;
    return ++li;
  }

  private int inserirArea () throws Exception { 
    area.insereItem (this.ultLido);
    return area.obterNumCelOcupadas ();
  }

  private int escreveMax (int es) throws Exception {
    arqLEs.seek ((es - 1) * MeuItem.tamanho ());
    this.ultLido.gravaArq (arqLEs);
    return --es;
  }

  private int escreveMin (int ei) throws IOException {
    this.ultLido.gravaArq (arqEi);
    return ++ei;
  }

  private int retiraMax () throws Exception {
    this.ultLido = (MeuItem) area.retiraUltimo ();
    return area.obterNumCelOcupadas ();
  }

  private int retiraMin () throws Exception {
    this.ultLido = (MeuItem) area.retiraPrimeiro ();
    return area.obterNumCelOcupadas ();
  }

  private LimiteParticoes particao (int esq, int dir) throws Exception {
    int ls = dir, es = dir, li = esq, ei = esq, nrArea = 0;
    MeuItem linf = new MeuItem (Integer.MIN_VALUE); // @$-\infty$@
    MeuItem lsup = new MeuItem (Integer.MAX_VALUE); // @$\infty$@
    this.ondeLer = true;
    LimiteParticoes p = new LimiteParticoes ();
    this.area = new Area (this.tamArea);
    arqLi.seek ((li - 1) * MeuItem.tamanho ());
    arqEi.seek ((ei - 1) * MeuItem.tamanho ());
    p.i = esq - 1; p.j = dir + 1;
    while (ls >= li) {
      if (nrArea < this.tamArea - 1) {
        if (ondeLer) ls = this.leSup (ls);
        else li = leInf (li);
        nrArea = inserirArea ();
      }
      else {
        if (ls == es) ls = leSup (ls);
        else if (li == ei) li = leInf (li);
        else if (ondeLer) ls = leSup (ls);
        else li = leInf (li);
        if (ultLido.compara (lsup) > 0) {
          p.j = es; es = escreveMax (es);
        }
        else if (ultLido.compara (linf) < 0) {
          p.i = ei; ei = escreveMin (ei);
        }
        else {
          nrArea = inserirArea ();
          if (ei - esq < dir - es) {
            nrArea = retiraMin (); linf = this.ultLido; ei = escreveMin (ei);
          }
          else {
            nrArea = retiraMax (); lsup = this.ultLido; es = escreveMax (es);
          }
        }
      }
    }
    while (ei <= es) { nrArea = retiraMin (); ei = escreveMin (ei); }
    return p;
  }

  public QuicksortExterno (String nomeArq, int tamArea) throws FileNotFoundException {
    this.arqLi   = new RandomAccessFile (nomeArq, "rws");
    this.arqEi   = new RandomAccessFile (nomeArq, "rws");
    this.arqLEs  = new RandomAccessFile (nomeArq, "rws");
    this.tamArea = tamArea;
  }

public void quicksortExterno (int esq, int dir) throws Exception {
  if (dir - esq < 1) return;
  LimiteParticoes p = particao (esq, dir);
  if (p.i - esq < dir - p.j) { // @{\it ordene primeiro o subarquivo menor}@
    quicksortExterno (esq, p.i); quicksortExterno (p.j, dir);
  }
  else { quicksortExterno (p.j, dir); quicksortExterno (esq, p.i); }
}

  public void fechaArquivos () throws Exception {
    this.arqEi.close ();
    this.arqLi.close ();
    this.arqLEs.close ();
  }
}
