#ifndef _TESTATABELA_H_
#define _TESTATABELA_H_
#include "Tabela.h" // @{\it vide Programa~\ref{c_5.1}}@
#include "../cap4/MeuItem.h" // @{\it vide Programa~\ref{c_4.1}}@
#include "../cap4/PermutacaoRandomica.h" // @{\it vide Programa~\ref{c_4.24}}@
#include<iostream>
using std::cout;
using std::endl;
using cap4::MeuItem;
using cap4::PermutacaoRandomica;
namespace cap5 {
  class TestaTabela {
  public:
    static void main (); 
  };
  
  void TestaTabela::main () {
    int maxN = 10;
    Tabela<int>* T = new Tabela<int>(maxN);
    MeuItem *reg = NULL;
    int *vetor = new int[maxN + 1];
    int  i;      
    // @{\it Pesquisa na Tabela Vazia}@
    cout << "Pesquisa Binaria na tabela vazia" << endl;
    reg = new MeuItem (1);
    int pos = T->binaria(reg);
    if (pos != 0) { 
      cout << "Pesquisa Falhou" << endl; exit (1);
    }
    delete reg;
    
    cout << "Pesquisa Sequencial na tabela vazia" << endl;
    reg = new MeuItem (1);    
    pos = T->pesquisa(reg);
    if (pos != 0) { 
      cout << "Pesquisa Falhou" << endl; exit (1);
    }
    delete reg;

    // @{\it Insere as chaves ordenas na tabela}@
    for (i = 1; i <= maxN; i++) { 
      vetor[i] = i;
      reg = new MeuItem (vetor[i]);
      T->insere (reg);
      cout << "Inseriu: " << vetor[i] << endl;
    }

    // @{\it Pesquisa bin\'aria em cada chave}@
    cout << "Pesquisa Binaria (chaves ordenadas)" << endl;
    for (i = 1; i <= maxN; i++) {
      reg = new MeuItem (i);
      pos = T->binaria (reg);
      if (pos == 0) { 
        cout << "Pesquisa Falhou" << endl; exit (1);
      }
      cout << "Registro " << i << " na posicao: " << pos << endl;
      delete reg;
    }

    // @{\it Permuta as chaves}@
    PermutacaoRandomica::permut (vetor, maxN + 1);
    // @{\it Insere as chaves na tabela}@
    delete T;
    T = new Tabela<int> (maxN); 
    for (i = 1; i <= maxN; i++) {
      reg = new MeuItem (vetor[i]);
      T->insere (reg);
      cout << "Inseriu: " << vetor[i] << endl;
    }
    // @{\it Pesquisa seq\"u\^encial em cada chave}@
    cout << "Pesquisa Sequencial (chaves desordenadas)" << endl;
    for (i = 1; i <= maxN; i++) {
      reg = new MeuItem (i);       
      pos = T->pesquisa (reg);
      if (pos == 0) { 
        cout << "Pesquisa Falhou" << endl; exit (1);
      }
      cout << "Registro " << i << " na posicao: " << pos << endl;
      delete reg;
    }
    delete T;
    delete []vetor;
  }    
}

#endif
