#ifndef _TABELAHASH_H_
#define _TABELAHASH_H_
#include <string>
#include <iostream>
using std::cout;
using std::endl;
using std::string;

namespace cap5_endaberto {
  // @{\it Para utilizar a classe TabelaHash<T> o tipo de dado fornecido no}@ 
  // @{\it lugar do par\^ametro de tipo T deve possuir um construtor de}@ 
  // @{\it c\'opia e os operadores <<, e = sobrecarregados.}@  
  template <class T> class TabelaHash {
  private: 
    class Celula {
    friend class TabelaHash<T>;
    private:
      string chave; T *item; bool retirado;
    public: 
      Celula (string chave, const T& item) {
        this->chave = chave; this->item = new T (item);
        this->retirado = false;
      }
      bool equals (Celula &cel) const {
        return (chave == cel.chave);
      }      
      ~Celula () { if (item != 0) delete item; }
    };
    int M; // @{\it tamanho da tabela}@
    Celula **tabela;
    int *pesos;
  
    int *geraPesos (int n) const;
    int h (string chave, int* pesos) const;
    int pesquisaIndice (string chave) const;
  public:
    TabelaHash (int m, int maxTamChave);    
    T *pesquisa (string chave) const;
    void insere (string chave, const T& item);
    void retira (string chave);
    T **recuperaItens (int &n) const;    
    void imprime () const;
    ~TabelaHash ();    
  };
  template <class T>    
  int *TabelaHash<T>::geraPesos (int n) const {
    int *p = new int[n];
    for (int i = 0; i < n; i++) p[i] = (rand () % M) + 1;
    return p;
  }

  template <class T>    
  int TabelaHash<T>::h (string chave, int* pesos) const {
    int soma = 0;
    for (unsigned int i = 0; i < chave.length(); i++) 
      soma = soma + ((unsigned char)chave[i]) * pesos[i]; 
    return soma % this->M;
  }
  
  template <class T>    
  int TabelaHash<T>::TabelaHash<T>::pesquisaIndice (string chave) const {
    int inicial = this->h (chave, this->pesos);
    int indice = inicial; int i = 0;
    while (this->tabela[indice] != NULL &&
           (chave != this->tabela[indice]->chave) &&
           i < this->M)  indice = (inicial + (++i)) % this->M; 
    if (this->tabela[indice] != NULL && 
        (this->tabela[indice]->chave == chave)) return indice;
    else return this->M;   // @{\it pesquisa sem sucesso}@
  }    
  
  template <class T>    
  TabelaHash<T>::TabelaHash (int m, int maxTamChave) {
    this->M = m; this->tabela = new Celula*[this->M];
    for (int i = 0; i < this->M; i++) this->tabela[i] = NULL; // @{\it vazio}@
    this->pesos = this->geraPesos (maxTamChave);
  }  
  
  template <class T>      
  T *TabelaHash<T>::pesquisa (string chave) const {
    int indice = this->pesquisaIndice (chave);
    if (indice < this->M) return this->tabela[indice]->item;
    else return NULL;   // @{\it pesquisa sem sucesso}@
  }
  
  template <class T>      
  void TabelaHash<T>::insere (string chave, const T& item) {
    if (this->pesquisa (chave) == NULL) {
      int inicial = this->h (chave, this->pesos);
      int indice = inicial; int i = 0;
      while (this->tabela[indice] != NULL &&
             !this->tabela[indice]->retirado &&
             i < this->M) indice = (inicial + (++i)) % this->M;
      if (i < this->M) this->tabela[indice] = new Celula (chave, item);
      else cout << "Tabela cheia" << endl;      
    } else cout << "Registro ja esta presente" << endl;    
  }
  
  template <class T>      
  void TabelaHash<T>::retira (string chave) {
    int i = this->pesquisaIndice (chave);
    if (i < this->M) {
      this->tabela[i]->retirado = true; this->tabela[i]->chave = "";
    } else cout << "Registro nao esta presente" << endl;
  }
   
  template <class T>      
  T **TabelaHash<T>::recuperaItens (int &n) const {
    n = 0;
    for (int i = 0; i < this->M; i++)
      if (this->tabela[i] != NULL && !this->tabela[i]->retirado) n++;
    T **itens = new T*[n]; n = 0;
    for (int i = 0; i < this->M; i++)
      if (this->tabela[i] != NULL && !this->tabela[i]->retirado) 
        itens[n++] = this->tabela[i]->item;   
    return itens;
  }
  
  template <class T>      
  void TabelaHash<T>::imprime () const {
    for (int i = 0; i < this->M; i++) {
      if (this->tabela[i] != NULL && !this->tabela[i]->retirado) {
        cout << "Entrada[" << i << "]:" << *(this->tabela[i]->item) << endl; 
      }
    }
  }
  
  template <class T>      
  TabelaHash<T>::~TabelaHash () {
    for (int i = 0; i < this->M; i++) 
      if(this->tabela[i] != NULL) delete this->tabela[i];
    delete [] this->tabela;
    delete [] this->pesos;
  }
}

#endif 
