#ifndef FHPM_H_
#define FHPM_H_
#include "../../cap7/listaadj/arranjo/Grafo.h" // @{\it vide Programa~\ref{c_7.6}@
#include <iostream>
#include <fstream>
#include <stdexcept> 
#include <string>
using std::string;
using std::logic_error;
using cap7_listaadj_arranjo::Grafo; // @{\it vide Programa~\ref{c_7.6}@
using std::ios;
using std::filebuf;
using std::istream;
using std::ostream;
namespace cap5_fhpm {
	class FHPM {
	private:
	  int *p1, *p2; // @{\it pesos de h1 e h2}@
    int *g; // @{\it fun\c{c}\~ao g}@
    int N;   // @{\it n\'umero de chaves}@
    int M;   // @{\it n\'umero de v\'ertices}@
    int maxTamChave, nGrafosGerados, nGrafosConsiderados; 
    const int Indefinido; 
	  int *geraPesos (int maxTamChave);
	  int h (string chave, int *pesos);
	  Grafo *geraGrafo (string *conjChaves);
	  bool rotuleDe (int v, int c, Grafo *grafo);
	  bool atribuig (Grafo *grafo);
  public:
	  FHPM (int maxTamChave, int n, float c);
	  void obtemHashingPerfeito (string nomeArqEnt) throw ( logic_error );
	  void salvar (string nomeArqSaida);
	  void ler (string nomeArqFHPM);
	  int hp (string chave);
	  ~FHPM ();
	};
  int *FHPM::geraPesos (int maxTamChave) {
    int *p = new int[maxTamChave];
    for (int i = 0; i < maxTamChave; i++) 
      p[i] = (rand () % 1000000) + 1; 
    return p;
  }
  int FHPM::h (string chave, int *pesos) {
    int soma = 0;
    for (unsigned int i = 0; i < chave.length(); i++) 
      soma = soma + ((unsigned char)chave[i]) * pesos[i]; 
    return soma % this->M;

  }
  Grafo *FHPM::geraGrafo (string *conjChaves) {
    Grafo *grafo; bool grafoValido;
    do {
      grafo = new Grafo (this->M, this->N); grafoValido = true;
      if (this->p1) delete [] this->p1;
      this->p1 = this->geraPesos (this->maxTamChave); 
      if (this->p2) delete [] this->p2;
      this->p2 = this->geraPesos (this->maxTamChave);
      for (int i = 0; i < this->N; i++) {
        int v1 = this->h (conjChaves[i], this->p1);
        int v2 = this->h (conjChaves[i], this->p2);
        if ((v1 == v2) || grafo->existeAresta(v1, v2)) {
          grafoValido=false; delete grafo; grafo = NULL; break;
        } else {
          grafo->insereAresta (v1, v2, i);
          grafo->insereAresta (v2, v1, i);
        }
      }
      this->nGrafosGerados ++;
    } while (!grafoValido);
    return grafo;
  }	  
  bool FHPM::rotuleDe (int v, int c, Grafo *grafo) {
    bool grafoRotulavel = true;
    if (this->g[v] != Indefinido) {
      if (this->g[v] != c) {
        this->nGrafosConsiderados++; grafoRotulavel = false;
      }
    } else {
      this->g[v] = c;
      if (!grafo->listaAdjVazia (v)) {
        Grafo::Aresta *adj = grafo->primeiroListaAdj (v);
        while (adj != NULL) {
          int u = adj->_peso () - this->g[v];
          if (u < 0) u = u + this->N;
          grafoRotulavel = rotuleDe (adj->_v2 (), u, grafo);
          delete adj;
          if (!grafoRotulavel) break; // @{\it sai do loop}@
          adj = grafo->proxAdj (v);
        }
      }
    }
    return grafoRotulavel;
  }	  
  bool FHPM::atribuig (Grafo *grafo) {
    bool grafoRotulavel = true;
    for (int v = 0; v < this->M; v++) this->g[v] = Indefinido;
    for (int v = 0; v < this->M; v++) {
      if (this->g[v] == Indefinido) 
        grafoRotulavel = this->rotuleDe (v, 0, grafo);
      if (!grafoRotulavel) break;
    }
    return grafoRotulavel;
  }
  FHPM::FHPM (int maxTamChave, int n, float c) : Indefinido (-1) {
    this->N  = n; this->M  = (int)(c*this->N);
    this->maxTamChave = maxTamChave; this->p1 = NULL;
    this->p2 = NULL; this->g = new int[this->M];    
  }
  void FHPM::obtemHashingPerfeito (string nomeArqEnt) throw ( logic_error ) {
  	filebuf fArqEnt; fArqEnt.open (nomeArqEnt.c_str(), ios::in);
  	istream arqEnt (&fArqEnt);
    string *conjChaves = new string[this->N];
    this->nGrafosGerados = 0; this->nGrafosConsiderados = 0;  int i = 0;
    while (i < this->N) {
    	char chave[this->maxTamChave+1];
    	arqEnt.getline (chave, this->maxTamChave+1);	    	
      if (strlen (chave) == 0) break; // @{\it fim de arquivo}@
      conjChaves[i] = chave; i++;
    }
    if (i != this->N) 
      throw logic_error ("Erro: Arquivo de entrada possui menos chaves");
    bool grafoRotulavel = true;
    do {    
      Grafo *grafo = this->geraGrafo (conjChaves);
      grafoRotulavel = this->atribuig (grafo);
      delete grafo;
    }while (!grafoRotulavel);
    delete [] conjChaves; fArqEnt.close (); 
  }  
  void FHPM::salvar (string nomeArqSaida) {
  	filebuf fArqSaida; fArqSaida.open (nomeArqSaida.c_str(), ios::out);
	  ostream arqSaida (&fArqSaida);  
    arqSaida << this->N << " (N)\n"; 
    arqSaida << this->M << " (M)\n";
    arqSaida << this->maxTamChave << " (maxTamChave)\n";
    for (int i = 0; i < this->maxTamChave; i++) 
      arqSaida << this->p1[i] << " ";
    arqSaida << "(p1)\n";
    for (int i = 0; i < this->maxTamChave; i++) 
      arqSaida << this->p2[i] << " ";
    arqSaida << "(p2)\n";
    for (int i = 0; i < this->M; i++) 
      arqSaida << this->g[i] << " ";
    arqSaida << "(g)\n";
    arqSaida << "No. grafos gerados por geraGrafo:" << 
                this->nGrafosGerados << "\n";
    arqSaida << "No. grafos considerados por atribuig:" <<
                (this->nGrafosConsiderados + 1) << "\n";
    fArqSaida.close ();
  }	
  void FHPM::ler (string nomeArqFHPM) {
  	filebuf fArqFHPM; fArqFHPM.open (nomeArqFHPM.c_str(), ios::in);
	  istream arqFHPM (&fArqFHPM); 
	  arqFHPM >> this->N; arqFHPM.ignore (20, '\n');
	  arqFHPM >> this->M; arqFHPM.ignore (20, '\n');
	  arqFHPM >> this->maxTamChave; arqFHPM.ignore (20, '\n');
	  if (this->p1) delete [] this->p1;
	  this->p1 = new int[this->maxTamChave];
    for (int i = 0; i < this->maxTamChave; i++) arqFHPM >> this->p1[i];
    arqFHPM.ignore (20, '\n');
	  if (this->p2) delete [] this->p2;
    this->p2 = new int[this->maxTamChave];
    for (int i = 0; i < this->maxTamChave; i++) arqFHPM >> this->p2[i];
    arqFHPM.ignore (20, '\n');
	  if (this->g) delete [] this->g;
    this->g = new int[this->M];
    for (int i = 0; i < this->M; i++) arqFHPM >> this->g[i];
    arqFHPM.ignore (20, '\n'); fArqFHPM.close ();
  }	
  int FHPM::hp (string chave) {
    return (g[h (chave, p1)] + g[h (chave, p2)]) % N;
  }				  
  FHPM::~FHPM () {
    if(this->p1) delete [] this->p1;    
    if(this->p2) delete [] this->p2;    
    if(this->g) delete [] this->g;    	    	    
  }

}

#endif
