#ifndef _TESTAARVOREBINARIA_H_
#define _TESTAARVOREBINARIA_H_
#include "ArvoreBinaria.h" // @{\it vide Programa~\ref{c_5.4}}@
#include "../cap4/MeuItem.h" // @{\it vide Programa~\ref{c_4.1}}@
#include "../cap4/PermutacaoRandomica.h" // @{\it vide Programa~\ref{c_4.24}}@
#include<iostream>
using std::cout;
using std::endl;
using cap4::Item;
using cap4::MeuItem;
using cap4::PermutacaoRandomica;
namespace cap5 {
  class TestaArvoreBinaria {
  public:
   static void main ();
  };
  void TestaArvoreBinaria::main () {
    ArvoreBinaria<int> *dicionario = new ArvoreBinaria<int> ();
    int max = 10;
    
    Item<int> *x = NULL;
    int *vetor = new int[max];

    for (int i = 0; i < max; i++)
      vetor[i] = i;

    // @{\it Gera uma permuta\c{c}\~ao aleat\'oria de chaves entre 0 e max-1}@
    PermutacaoRandomica::permut (vetor, max);
    
    // @{\it Insere cada chave na \'arvore e testa sua integridade ap\'os cada inser\c{c}\~ao}@
    for (int i = 0; i < max; i++) { 
      x = new MeuItem (vetor[i]);
      dicionario->insere (x);
      cout << "Inseriu chave: " << x->toString() << endl;
      dicionario->testa ();
    }
    // @{\it Retira uma chave aleatoriamente e realiza v\'arias pesquisas}@
    for (int i = 0; i < max; i++) {
      int k =  rand () % max;
      int n = vetor[k];
      x = new MeuItem (n);
      dicionario->retira (x);
      dicionario->testa ();
      cout << "Retirou chave: " <<  x->toString() << endl;
      delete x;
      for (int j = 0; j < max; j++) { 
        k =  rand () % 10;
        x = new MeuItem (k);
        Item<int> *aux = x;
        Item<int> *reg = new MeuItem(n);
        if (x->compara (reg) != 0 ) { 
          cout << "Pesquisando chave: " << x->toString();
          x = dicionario->pesquisa (aux);
          cout << " , encontrou:" << x->toString() << endl;
        }
        delete aux;
        delete reg;
      }
      x = new MeuItem (n);
      dicionario->insere (x);
      cout << "Inseriu chave: " << x->toString() << endl;
      dicionario->testa ();
    }

    // @{\it Retira a raiz da \'arvore at\'e que ela fique vazia}@
    for (int i = 0; i < max; i++) { 
      x = new MeuItem (vetor[i]);
      dicionario->retira (x);
      dicionario->testa ();
      cout << "Retirou chave: " << x->toString() << endl;
      delete x;
    }
    delete vetor;
    delete dicionario;
  }
}
#endif 
