#ifndef _EXTRAIPALAVRA_H_
#define _EXTRAIPALAVRA_H_
#include <string>
#include <iostream>
#include <fstream>
using std::ios;
using std::filebuf;
using std::istream;
using std::string;
#define ASCII 256
#define MAX_TAM_LINHA 200
namespace cap5 {
  class ExtraiPalavra {
  private:
    istream *arqDelim, *arqTxt;
    filebuf fArqDelim, fArqTxt;
    string *delimitadores;
    string *palavras;
    string::size_type pos;
  public:
    ExtraiPalavra (string nomeArqDelim, string nomeArqTxt);    
    string *proximaPalavra ();      
    ~ExtraiPalavra (); // @{\it Fecha os arquivos e libera mem\'oria alocada}@
  };
  ExtraiPalavra::ExtraiPalavra (string nomeArqDelim, string nomeArqTxt) {
    this->fArqDelim.open (nomeArqDelim.c_str(), ios::in);
    this->arqDelim = new istream(&this->fArqDelim);
    this->fArqTxt.open (nomeArqTxt.c_str(), ios::in);
    this->arqTxt = new istream(&this->fArqTxt);      
    // @{\it Os delimitadores devem estar juntos em uma \'unica linha do arquivo}@ 
    char delim[ASCII];
    arqDelim->getline(delim, ASCII);
    this->delimitadores = new string(delim);
    *(this->delimitadores) =  *(this->delimitadores) + "\r\n"; 
    this->palavras = NULL; this->pos = 0;
  }     
  
  string *ExtraiPalavra::proximaPalavra () {
    if (palavras == NULL || (this->pos == string::npos)) {
      char linha[MAX_TAM_LINHA];
      arqTxt->getline (linha, MAX_TAM_LINHA);
      if (strlen (linha) == 0 && arqTxt->eof ()) return NULL;
      if (this->palavras) delete this->palavras;
      this->palavras = new string (linha);  this->pos = 0;
    }
    string *palavra = new string("");
    this->pos = this->palavras->find_first_not_of(*(this->delimitadores), 
                                                  this->pos);
    string::size_type posFinal = this->palavras->find_first_of (
                                 *(this->delimitadores), this->pos);
    if (string::npos != posFinal || string::npos != this->pos) {
      *palavra = this->palavras->substr(this->pos, posFinal - this->pos);
      this->pos = posFinal;
    }
    return palavra;
  }      
  ExtraiPalavra::~ExtraiPalavra () { 
      this->fArqDelim.close();
      delete this->arqDelim;
      this->fArqTxt.close();
      delete this->arqTxt;
      delete this->delimitadores;
      if(this->palavras) delete this->palavras;
  }    
}
#endif
