#ifndef _ARVORESBB_H_
#define _ARVORESBB_H_
#include "../cap4/Item.h"  // @{\it vide Programa~\ref{c_4.0}}@
#include <iostream>
#include <stdexcept> 
using std::logic_error;
using std::cout;
using std::endl;
using cap4::Item;
namespace cap5 {
  template <class TipoChave> class ArvoreSBB {
  private:
    class No {
    friend class ArvoreSBB<TipoChave>; 
    private:
      Item<TipoChave> *reg; 
      No *esq, *dir; 
      unsigned char incE, incD;      
      No () { reg = 0;} ~No () { if (reg != 0) delete reg; }
    };
    const unsigned char Horizontal; 
    const unsigned char Vertical; 
    No *raiz;
    bool propSBB;
    
    void central (No *p) const;
    Item<TipoChave> *pesquisa (Item<TipoChave> *reg, No *p) const;
    // @{\it Transfoma\c{c}\~oes}@
    No *ee (No *ap);
    No *ed (No *ap);
    No *dd (No *ap);
    No *de (No *ap); 
    No *insere (Item<TipoChave> *reg, No *pai, No *filho, bool filhoEsq);
    // @{\it Folha esquerda retirada => \'arvore curta na altura esquerda}@
    No *esqCurto (No *ap); 
    // @{\it Folha direita retirada => \'arvore curta na altura direita}@
    No *dirCurto (No *ap);
    No *antecessor (No *q, No *r);
    No *retira (Item<TipoChave> *reg, No *p);
    void liberaMemoria (No *p);
  public:
    ArvoreSBB ();
    Item<TipoChave> *pesquisa (Item<TipoChave> *reg);
    void insere (Item<TipoChave> *reg);
    void retira (Item<TipoChave> *reg);
    void imprime () const; 
    ~ArvoreSBB ();
  // @{\it Campos e m\'etodos para testar o funcionamento da classe}@ 
  private: 
    bool primeiraFolha;
    int nivelFolhas;   
    void testa1 (No *p, int nivel); 
    void testa2 (No *p); 
    void testa(No *Arvore);
  public:
    void testa ();
  };

  template <class TipoChave>
  void ArvoreSBB<TipoChave>::central (No *p) const {
    if (p != NULL) {
      central (p->esq);
      cout << "No:" << p->reg->toString();
      cout << " -- IncE:" << (int)(p->incE);
      cout << " -- IncD:" << (int)(p->incD) << endl;
      central (p->dir);
    }
  }
  template <class TipoChave> Item<TipoChave> *ArvoreSBB<TipoChave>::  
  pesquisa (Item<TipoChave> *reg, No *p) const {
    if (p == NULL) return NULL; // @{\it Registro n\~ao econtrado}@
    else if (reg->compara (p->reg) < 0) return pesquisa (reg, p->esq);
    else if (reg->compara (p->reg) > 0) return pesquisa (reg, p->dir);
    else return p->reg;
  }
  
  template <class TipoChave> 
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::ee (No *ap) {
    No *ap1 = ap->esq; ap->esq = ap1->dir; ap1->dir = ap;
    ap1->incE = Vertical; ap->incE = Vertical; ap = ap1;
    return ap; 
  }
  
  template <class TipoChave>
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::ed (No *ap) {
    No *ap1 = ap->esq; No *ap2 = ap1->dir; ap1->incD = Vertical;
    ap->incE = Vertical; ap1->dir = ap2->esq; ap2->esq = ap1;
    ap->esq = ap2->dir; ap2->dir = ap; ap = ap2;    
    return ap; 
  }

  template <class TipoChave>
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::dd (No *ap) {
    No *ap1 = ap->dir; ap->dir = ap1->esq; ap1->esq = ap;
    ap1->incD = Vertical; ap->incD = Vertical; ap = ap1;
    return ap; 
  }

  template <class TipoChave>
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::de (No *ap) {
    No *ap1 = ap->dir; No *ap2 = ap1->esq; ap1->incE = Vertical;
    ap->incD = Vertical; ap1->esq = ap2->dir; ap2->dir = ap1;
    ap->dir = ap2->esq; ap2->esq = ap; ap = ap2;    
    return ap; 
  }
    
  template <class TipoChave>  
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::
  insere (Item<TipoChave> *reg, No *pai, No *filho, bool filhoEsq) {
    if (filho == NULL) {
      filho = new No (); filho->reg = reg; 
      filho->incE = Vertical; filho->incD = Vertical;
      filho->esq = NULL; filho->dir = NULL;
      if (pai != NULL)
        if (filhoEsq) pai->incE = Horizontal; else pai->incD = Horizontal;
      this->propSBB = false;
    }
    else if (reg->compara (filho->reg) < 0) {
      filho->esq = insere (reg, filho, filho->esq, true);
      if (!this->propSBB) 
        if (filho->incE == Horizontal) { 
          if (filho->esq->incE == Horizontal) {
            filho = this->ee (filho); // @{\it trasforma\c{c}\~ao esquerda-esquerda}@
            if (pai != NULL)
              if (filhoEsq) pai->incE=Horizontal; else pai->incD=Horizontal;
          }
          else if (filho->esq->incD == Horizontal) {
            filho = this->ed (filho); // @{\it trasforma\c{c}\~ao esquerda-direita}@
            if (pai != NULL) 
              if (filhoEsq) pai->incE=Horizontal; else pai->incD=Horizontal;            
          }
        }
        else this->propSBB = true;
    }
    else if (reg->compara (filho->reg) > 0) {
      filho->dir = insere (reg, filho, filho->dir, false);
      if (!this->propSBB) 
        if (filho->incD == Horizontal) {
          if (filho->dir->incD == Horizontal) {
            filho = this->dd (filho); // @{\it trasforma\c{c}\~ao direita-direita}@
            if (pai != NULL)
              if (filhoEsq) pai->incE=Horizontal; else pai->incD=Horizontal;
          }
          else if (filho->dir->incE == Horizontal) {
            filho = this->de (filho); // @{\it trasforma\c{c}\~ao direita-esquerda}@
            if (pai != NULL)
              if (filhoEsq) pai->incE=Horizontal; else pai->incD=Horizontal;            
          }
        }
        else this->propSBB = true;
    }
    else {      
      cout << "Erro: Registro ja existente" << endl; 
      this->propSBB = true;
    }
    return filho; 
  }
  
  // @{\it Folha esquerda retirada => \'arvore curta na altura esquerda}@
  template <class TipoChave>  
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::
  esqCurto (No *ap) {
    if (ap->incE == Horizontal) {ap->incE=Vertical; this->propSBB=true;}
    else if (ap->incD == Horizontal) {
      No *ap1 = ap->dir; ap->dir = ap1->esq; ap1->esq = ap; ap = ap1;
      if (ap->esq->dir->incE == Horizontal) {
        ap->esq = this->de (ap->esq); ap->incE = Horizontal;
      }
      else if (ap->esq->dir->incD == Horizontal) {        
        ap->esq = this->dd (ap->esq); ap->incE = Horizontal;
      } this->propSBB = true;
    }
    else {
      ap->incD = Horizontal;
      if (ap->dir->incE == Horizontal) {
        ap = this->de (ap); this->propSBB = true;
      }
      else if (ap->dir->incD == Horizontal) {
        ap = this->dd (ap); this->propSBB = true;
      } 
    }
    return ap;
  }

  
  // @{\it Folha direita retirada => \'arvore curta na altura direita}@
  template <class TipoChave>  
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::
  dirCurto (No *ap) {
    if (ap->incD == Horizontal) {
      ap->incD = Vertical; this->propSBB = true;
    }
    else if (ap->incE == Horizontal) {
      No *ap1 = ap->esq; ap->esq = ap1->dir; ap1->dir = ap; ap = ap1;
      if (ap->dir->esq->incD == Horizontal) {
        ap->dir = this->ed (ap->dir); ap->incD = Horizontal;
      }
      else if (ap->dir->esq->incE == Horizontal) {        
        ap->dir = this->ee (ap->dir); ap->incD = Horizontal;
      }
      this->propSBB = true;
    }
    else {
      ap->incE = Horizontal;
      if (ap->esq->incD == Horizontal) {
        ap = this->ed (ap); this->propSBB = true;
      }
      else if (ap->esq->incE == Horizontal) {
        ap = this->ee (ap); this->propSBB = true;
      } 
    }
    return ap;
  }

  template <class TipoChave>  
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::
  antecessor (No *q, No *r) {
    if (r->dir != NULL) {
      r->dir = antecessor (q, r->dir);
      if (!this->propSBB) r = this->dirCurto (r);
    }
    else {
      delete q->reg; q->reg = r->reg; 
      r->reg = NULL; // @{\it transfere a posse da mem\'oria}@
      No *aux = r; r = r->esq; delete aux;
      if (r != NULL) this->propSBB = true;
    }
    return r;
  }
  
  template <class TipoChave>  
  typename ArvoreSBB<TipoChave>::No *ArvoreSBB<TipoChave>::
  retira (Item<TipoChave> *reg, No *ap) {
    if (ap == NULL) {
      cout << "Erro: Registro nao encontrado" << endl;
      this->propSBB = true;
    }
    else if (reg->compara (ap->reg) < 0) {
      ap->esq = retira (reg, ap->esq);
      if (!this->propSBB) 
        ap = this->esqCurto (ap);
    }
    else if (reg->compara (ap->reg) > 0) {
      ap->dir = retira (reg, ap->dir);
      if (!this->propSBB) 
        ap = this->dirCurto (ap);
    }
    else { // @{\it encontrou o registro}@
      this->propSBB = false; 
      if (ap->dir == NULL) {
        No *aux = ap; 
        ap = ap->esq; 
        delete aux;
        if (ap != NULL) 
          this->propSBB = true;
      }
      else if (ap->esq == NULL) {
        No *aux = ap; 
        ap = ap->dir; 
        delete aux;
        if (ap != NULL) 
          this->propSBB = true;
      }
      else {
        ap->esq = antecessor (ap, ap->esq); 
        if (!this->propSBB) 
          ap = this->esqCurto (ap);
      }
    }
    return ap; 
  }
  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::liberaMemoria (No *p) {
    if (p != NULL) {
      liberaMemoria (p->esq); 
      liberaMemoria (p->dir); 
      delete p;
    }
  }

  template <class TipoChave> ArvoreSBB<TipoChave>::ArvoreSBB ():
  Horizontal (0), Vertical (1) {
    this->raiz = NULL;
    this->propSBB = true;
  }
  template <class TipoChave> Item<TipoChave> *ArvoreSBB<TipoChave>::
  pesquisa (Item<TipoChave> *reg) {
    return this->pesquisa (reg, this->raiz);
  }
  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::insere (Item<TipoChave> *reg) {
    this->raiz = insere (reg, NULL, this->raiz, true);
  }
  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::retira (Item<TipoChave> *reg) {
    this->raiz = this->retira (reg, this->raiz);
  }  
  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::imprime () const {
    this->central (this->raiz);
  }
  template <class TipoChave>  
  ArvoreSBB<TipoChave>::~ArvoreSBB () {
    this->liberaMemoria (this->raiz);
  }

  // @{\it Campos e m\'etodos para testar o funcionamento da classe}@ 
  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::testa1 (No *p, int nivel) { 
    if (p == NULL) return;
    if (this->primeiraFolha)
      if (this->nivelFolhas < nivel)  this->nivelFolhas = nivel;
    if (p->esq == NULL && p->dir == NULL) { 
      if (this->primeiraFolha) this->primeiraFolha = false;
      else { 
        if (nivel != this->nivelFolhas) {
          cout << "Erro: Folhas em niveis diferentes" << endl;
          exit(1);
        }
      }
    }
    if (p->incE == Horizontal) this->testa1(p->esq, nivel);
    else this->testa1(p->esq, nivel + 1);
    if (p->incD == Horizontal) this->testa1(p->dir, nivel);
    else this->testa1(p->dir, nivel + 1);
  }

  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::testa2 (No *p) { 
    if (p == NULL) return;
    if (p->esq != NULL) { 
      if (p->reg->compara (p->esq->reg) < 0) { 
        cout << "Erro: Pai " << p->reg->toString() << " menor que filho a esquerda " << p->esq->reg->toString() << endl;
        exit(1);
      }
    }
    if (p->dir != NULL) { 
      if (p->reg->compara (p->dir->reg) > 0 ) { 
        cout << "Erro: Pai " << p->reg->toString() << " maior que filho a direita " << p->dir->reg->toString() << endl;
        exit(1);
      }
    }
    testa2(p->esq);
    testa2(p->dir);  	
  }
  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::testa (No *Arvore) { 
		this->nivelFolhas = 0;
    this->primeiraFolha = true;
    this->testa1(Arvore, 1);
    this->testa2(Arvore);		
  }
  template <class TipoChave>  
  void ArvoreSBB<TipoChave>::testa () { 
    this->testa (this->raiz);
  }
}
#endif
