package cap5;
import cap4.Item; // @{\it vide Programa~\ref{prog:interfaceitem}}@
import cap4.MeuItem; // @{\it vide Programa~\ref{prog:tipoitem}}@
import cap4.PermutacaoRandomica;

public class Tabela {
  private Item registros[];
  private int n;
  
  public Tabela (int maxN) {
    this.registros = new Item[maxN+1];
    this.n = 0;
  }
  public int pesquisa (Item reg) {
    this.registros[0] = reg; // @{\it sentinela}@
    int i = this.n; 
    while (this.registros[i].compara (reg) != 0) i--;
    return i;
  }
  public void insere (Item reg) throws Exception {
    if (this.n == (this.registros.length - 1))
      throw new Exception ("Erro: A tabela esta cheia");
    this.registros[++this.n] = reg;
  }
  public int binaria (Item chave) { 
    if (this.n == 0) return 0;
    int esq = 1, dir = this.n, i;
    do { 
      i = (esq + dir) / 2;
      if (chave.compara (this.registros[i]) > 0) esq = i + 1;
      else dir = i - 1;
    } while ((chave.compara (this.registros[i]) != 0) && (esq <= dir));
    if (chave.compara (this.registros[i]) == 0) return i;
    else return 0;
  }
  
  public static void main (String[] args) throws Exception {
    int maxN = 10;
    Tabela T = new Tabela (maxN);
    MeuItem reg = null;
    int vetor[] = new int[maxN + 1];
    int  i;

    // @{\it Pesquisa na Tabela Vazia}@
    System.out.println ("Pesquisa Binaria na tabela vazia");
    int pos = T.binaria(new MeuItem (1));
    if (pos != 0) { 
      System.out.println ("Pesquisa Falhou");
      System.exit (1);
    }
    System.out.println ("Pesquisa Sequencial na tabela vazia");
    pos = T.pesquisa(new MeuItem (1));
    if (pos != 0) { 
      System.out.println ("Pesquisa Falhou");
      System.exit (1);
    }

    // @{\it Insere as chaves ordenas na tabela}@
    for (i = 1; i <= maxN; i++) { 
      vetor[i] = i;
      reg = new MeuItem (vetor[i]);
      T.insere (reg);
      System.out.println ("Inseriu: " + vetor[i]);
    }

    // @{\it Pesquisa bin\'aria em cada chave}@
    System.out.println ("Pesquisa Binaria (chaves ordenadas)");
    for (i = 1; i <= maxN; i++) {
      pos = T.binaria (new MeuItem (i));
      if (pos == 0) { 
        System.out.println ("Pesquisa Falhou");
        System.exit (1);
      }
      System.out.println ("Registro " + i + " na posicao: " + pos);
    }

    // @{\it Permuta as chaves}@
    PermutacaoRandomica.permut (vetor, maxN + 1);

    // @{\it Insere as chaves na tabela}@
    T = new Tabela (maxN); 
    for (i = 1; i <= maxN; i++) {
      reg = new MeuItem (vetor[i]);
      T.insere (reg);
      System.out.println ("Inseriu: " + vetor[i]);
    }

    // @{\it Pesquisa seq\"u\^encial em cada chave}@
    System.out.println ("Pesquisa Sequencial (chaves desordenadas)");
    for (i = 1; i <= maxN; i++) {       
      pos = T.pesquisa (new MeuItem (i));
      if (pos == 0) { 
        System.out.println ("Pesquisa Falhou");
        System.exit (1);
      }
      System.out.println ("Registro " + i + " na posicao: " + pos);
    }
  }
}
