package cap5.fhpm;
import java.io.*;
import cap7.listaadj.arranjo.Grafo; // @{\it vide Programa~\ref{prog:estruturaslistapc}}@
public class FHPM {
  private int p1[], p2[]; // @{\it pesos de h1 e h2}@
  private int g[]; // @{\it fun\c{c}\~ao g}@
  private int N;   // @{\it n\'umero de chaves}@
  private int M;   // @{\it n\'umero de v\'ertices}@
  private int maxTamChave, nGrafosGerados, nGrafosConsiderados; 
  private final int Indefinido = -1;
  
  private int[] geraPesos (int maxTamChave) {
    int p[] = new int[maxTamChave];
    java.util.Random rand = new java.util.Random ();
    for (int i = 0; i < maxTamChave; i++) 
      p[i] = rand.nextInt(1000000) + 1;
    return p;
  }

  private int h (String chave, int pesos[]) {
    int soma = 0;
    for (int i = 0; i < chave.length(); i++) 
      soma = soma + ((int)chave.charAt (i)) * pesos[i]; 
    return soma % this.M;
  }

  private Grafo geraGrafo (String conjChaves[]) {
    Grafo grafo; boolean grafoValido;
    do {
      grafo = new Grafo (this.M, this.N); grafoValido = true;
      this.p1 = this.geraPesos (this.maxTamChave); 
      this.p2 = this.geraPesos (this.maxTamChave);
      for (int i = 0; i < this.N; i++) {
        int v1 = this.h (conjChaves[i], this.p1);
        int v2 = this.h (conjChaves[i], this.p2);
        if ((v1 == v2) || grafo.existeAresta(v1, v2)) {
          grafoValido = false; grafo = null; break;
        } else {
          grafo.insereAresta (v1, v2, i);
          grafo.insereAresta (v2, v1, i);
        }
      }
      this.nGrafosGerados ++;
    } while (!grafoValido);
    return grafo;
  }
  
  private boolean rotuleDe (int v, int c, Grafo grafo) {
    boolean grafoRotulavel = true;
    if (this.g[v] != Indefinido) {
      if (this.g[v] != c) {
        this.nGrafosConsiderados++; grafoRotulavel = false;
      }
    } else {
      this.g[v] = c;
      if (!grafo.listaAdjVazia (v)) {
        Grafo.Aresta adj = grafo.primeiroListaAdj (v);
        while (adj != null) {
          int u = adj.peso () - this.g[v];
          if (u < 0) u = u + this.N;
          grafoRotulavel = rotuleDe (adj.v2 (), u, grafo);
          if (!grafoRotulavel) break; // {\it sai do loop}@
          adj = grafo.proxAdj (v);
        }
      }
    }
    return grafoRotulavel;
  }
  
  private boolean atribuig (Grafo grafo) {
    boolean grafoRotulavel = true;
    for (int v = 0; v < this.M; v++) this.g[v] = Indefinido;
    for (int v = 0; v < this.M; v++) {
      if (this.g[v] == Indefinido) 
        grafoRotulavel = this.rotuleDe (v, 0, grafo);
      if (!grafoRotulavel) break;
    }
    return grafoRotulavel;
  }
  public FHPM (int maxTamChave, int n, float c) {
    this.N  = n; this.M  = (int)(c*this.N);
    this.maxTamChave = maxTamChave;
    this.g = new int[this.M];    
  }
  
  public void obtemHashingPerfeito (String nomeArqEnt) throws Exception {
    BufferedReader arqEnt   = new BufferedReader (
                              new FileReader (nomeArqEnt));
    String conjChaves[] = new String[this.N];
    this.nGrafosGerados = 0; this.nGrafosConsiderados = 0;  int i = 0;
    while ((i < this.N) && ((conjChaves[i] = arqEnt.readLine()) != null)) i++;
    if (i != this.N) 
      throw new Exception ("Erro: Arquivo de entrada possui menos que "+ 
                           this.N + " chaves");
    boolean grafoRotulavel = true;
    do {    
      Grafo grafo = this.geraGrafo (conjChaves);
      grafoRotulavel = this.atribuig (grafo);
    }while (!grafoRotulavel);
    arqEnt.close ();    
  }
  
  public void salvar (String nomeArqSaida) throws Exception {
    BufferedWriter arqSaida = new BufferedWriter (
                              new FileWriter (nomeArqSaida));
    arqSaida.write (this.N + " (N)\n"); 
    arqSaida.write (this.M + " (M)\n");
    arqSaida.write (this.maxTamChave + " (maxTamChave)\n");
    for (int i = 0; i < this.maxTamChave; i++) 
      arqSaida.write (this.p1[i] + " ");
    arqSaida.write ("(p1)\n");
    for (int i = 0; i < this.maxTamChave; i++) 
      arqSaida.write (this.p2[i] + " ");
    arqSaida.write ("(p2)\n");
    for (int i = 0; i < this.M; i++) 
      arqSaida.write (this.g[i] + " ");
    arqSaida.write ("(g)\n");
    arqSaida.write ("No. grafos gerados por geraGrafo:" + 
                     this.nGrafosGerados + "\n");
    arqSaida.write ("No. grafos considerados por atribuig:" + 
                    (this.nGrafosConsiderados + 1) + "\n");
    arqSaida.close ();
  }

  public void ler (String nomeArqFHPM) throws Exception {
    BufferedReader arqFHPM = new BufferedReader (
                             new FileReader (nomeArqFHPM));
    String temp = arqFHPM.readLine(), valor = temp.substring(0, 
                                              temp.indexOf (" "));
    this.N = Integer.parseInt (valor);
    temp = arqFHPM.readLine(); valor = temp.substring(0, 
                                       temp.indexOf (" "));
    this.M = Integer.parseInt (valor);
    temp = arqFHPM.readLine(); valor = temp.substring(0, 
                                       temp.indexOf (" "));
    this.maxTamChave = Integer.parseInt (valor);
    temp = arqFHPM.readLine(); int inicio = 0; 
    this.p1 = new int[this.maxTamChave];
    for (int i = 0; i < this.maxTamChave; i++) {
      int fim = temp.indexOf (' ', inicio); 
      valor = temp.substring(inicio, fim);
      inicio =  fim + 1; this.p1[i] = Integer.parseInt (valor);
    }
    temp = arqFHPM.readLine(); inicio = 0; 
    this.p2 = new int[this.maxTamChave];
    for (int i = 0; i < this.maxTamChave; i++) {
      int fim = temp.indexOf (' ', inicio); 
      valor = temp.substring(inicio, fim);
      inicio =  fim + 1; this.p2[i] = Integer.parseInt (valor);
    }
    temp = arqFHPM.readLine(); inicio = 0; 
    this.g = new int[this.M];
    for (int i = 0; i < this.M; i++) {
      int fim = temp.indexOf (' ', inicio); valor = 
      temp.substring(inicio, fim); 
      inicio =  fim + 1; this.g[i] = Integer.parseInt (valor);
    }
    arqFHPM.close();
  }

  public int hp (String chave) {
    return (g[h (chave, p1)] + g[h (chave, p2)]) % N;
  }
}
