#ifndef _ARVOREBESTRELA_H_
#define _ARVOREBESTRELA_H_
#include "../cap4/Item.h"  // @{\it vide Programa~\ref{c_4.0}}@
#include <typeinfo>
#include <iostream>
using std::cout;
using std::endl;
using cap4::Item;
namespace cap6 {
  template <class T, class TipoChave> class ArvoreBEstrela {
  private:
    class Pagina {
    friend class ArvoreBEstrela<T, TipoChave>; 
    protected:
      int n; Item<TipoChave> **chaves; 
    public:
      virtual ~Pagina (){}
    };
    class PaginaInt : public Pagina {
    friend class ArvoreBEstrela<T, TipoChave>; 
    private:
      Pagina **p; 
    public:
      PaginaInt (int mm) {
        this->n = 0; this->chaves = new Item<TipoChave>*[mm]; 
        this->p = new Pagina*[mm+1];
      }
      ~PaginaInt () {
        for (int i = 0; i < this->n; i++) {
          if (this->chaves[i] != 0) {
            delete this->chaves[i];
          }          
          this->p[i] = NULL;
        }
        this->p[this->n] = NULL; 
        delete [] this->chaves; delete [] this->p;        
      }
    };
    class PaginaExt : Pagina {
    friend class ArvoreBEstrela<T, TipoChave>; 
    private:
      T *registros; 
    public:
      PaginaExt (int mm2) {
        this->n = 0; this->chaves = new Item<TipoChave>*[mm2]; 
        this->registros = new T[mm2]; 
      }
      ~PaginaExt () {
        for (int i = 0; i < this->n; i++) {
          if (this->chaves[i] != 0) {
            delete this->chaves[i];
          }          
        }
        delete [] this->chaves; delete [] this->registros;        
      }
    };
    Pagina *raiz;
    int mm, mm2;
    // @{\it Verifica se ap \'e uma p\'agina interna}@ 
    bool eInterna (Pagina *ap) const;
    T *pesquisa (Item<TipoChave> *chave, Pagina *ap) const;
  public:
    ArvoreBEstrela (int mm, int mm2);
    T *pesquisa (Item<TipoChave> *chave) const;
  };
  template <class T, class TipoChave>
  bool ArvoreBEstrela<T, TipoChave>::eInterna (Pagina *ap) const {    
    return (strcmp(typeid(*ap).name(), typeid(PaginaInt).name()) == 0);    
  }    
  template <class T, class TipoChave>
  T *ArvoreBEstrela<T, TipoChave>::
  pesquisa (Item<TipoChave> *chave, Pagina *ap) const {
    if (ap == NULL) return NULL; // Registro @{\it n\~ao}@ econtrado
    else {
      if (this->eInterna (ap)) {
        int i = 0; PaginaInt *aux = (PaginaInt *)ap;
        while((i < aux->n-1)&&(chave->compara (aux->chaves[i]) > 0)) i++;
        if (chave->compara (aux->chaves[i]) < 0) 
          return pesquisa (chave, aux->p[i]);
        else return pesquisa (chave, aux->p[i+1]);
      }
      else {
        int i = 0; PaginaExt *aux = (PaginaExt *)ap;
        while((i < aux->n-1)&&(chave->compara (aux->chaves[i]) > 0)) i++;
        if (chave->compara (aux->chaves[i]) == 0) 
          return &(aux->registros[i]);
        return NULL; // @{\it Registro n\~ao econtrado}@
      }
    }
  }
  template <class T, class TipoChave>
  ArvoreBEstrela<T, TipoChave>::ArvoreBEstrela (int mm, int mm2) {
    this->raiz = NULL; this->mm = mm; this->mm2 = mm2;
  }
  template <class T, class TipoChave>
  T *ArvoreBEstrela<T, TipoChave>::
  pesquisa (Item<TipoChave> *chave) const {
    return this->pesquisa (chave, this->raiz);
  }
}
#endif 
