#ifndef _ARVOREB_H_
#define _ARVOREB_H_
#include "../cap4/Item.h"  // @{\it vide Programa~\ref{c_4.0}}@
#include <iostream>
using std::cout;
using std::endl;
using cap4::Item;
namespace cap6 {
  template <class TipoChave> class ArvoreB {
  private:
    class Pagina {
    friend class ArvoreB<TipoChave>; 
    private:
      int n; Item<TipoChave> **r; Pagina **p; 
    public:
      Pagina (int mm) { 
        this->n = 0; this->r = new Item<TipoChave>*[mm]; 
        this->p = new Pagina*[mm+1];
      } 
      ~Pagina() { 
        for (int i = 0; i < this->n; i++) {
          if (this->r[i] != 0) {
            delete this->r[i];
          }          
          this->p[i] = NULL;
        }
        this->p[this->n] = NULL; delete [] this->r; delete [] this->p;
      }
    };
    Pagina *raiz;
    int m, mm;
    void imprime (Pagina *p, int nivel) const;
    Item<TipoChave> *pesquisa (Item<TipoChave> *reg, Pagina *ap) const;    void insereNaPagina (Pagina *ap, Item<TipoChave> *&reg, Pagina *&apDir);
    Pagina *insere (Item<TipoChave> *reg, Pagina *ap, 
                    Item<TipoChave> *&regRetorno, bool &cresceu);
    bool reconstitui (Pagina *apPag, Pagina *apPai, int posPai);
    bool antecessor (Pagina *ap, int ind, Pagina *apPai);
    Pagina *retira (Item<TipoChave> *reg, Pagina *ap, bool & diminuiu);
    void liberaMemoria (Pagina *p);
  public:
    ArvoreB (int m);
    Item<TipoChave> *pesquisa (Item<TipoChave> *reg) const;
    void insere (Item<TipoChave> *reg);
    void retira (Item<TipoChave> *reg);
    void imprime () const;
    ~ArvoreB ();
  };

  template <class TipoChave>  
  void ArvoreB<TipoChave>::imprime (Pagina *p, int nivel) const {
    if (p != NULL) {
      cout << "  Nivel" << nivel << ":";
      for (int i = 0; i < p->n; i++)
        cout << " " << p->r[i]->toString();
      cout << endl;
      for (int i = 0; i <= p->n; i++) {
        if (p->p[i] != NULL)
          if (i < p->n) cout << "  Esq: " << p->r[i]->toString() << endl;
          else cout << "  Dir: " << p->r[i-1]->toString() << endl;
        imprime (p->p[i], nivel + 1);      
      }
    }
  }

  template <class TipoChave>  
  Item<TipoChave> *ArvoreB<TipoChave>::
  pesquisa (Item<TipoChave> *reg, Pagina *ap) const {
    if (ap == NULL) return NULL; // @{\it Registro n\~ao econtrado}@
    else {
      int i = 0;
      while ((i < ap->n-1) && (reg->compara (ap->r[i]) > 0)) i++;
      if (reg->compara (ap->r[i]) == 0) return ap->r[i];
      else if (reg->compara (ap->r[i]) < 0) return pesquisa (reg, ap->p[i]);
      else return pesquisa (reg, ap->p[i+1]);
    }
  }

  template <class TipoChave> void ArvoreB<TipoChave>::
  insereNaPagina(Pagina *ap,Item<TipoChave> *&reg, Pagina *&apDir) {
    int k = ap->n - 1;
    while ((k >= 0) && (reg->compara (ap->r[k]) < 0)) {
      ap->r[k+1] = ap->r[k]; ap->p[k+2] = ap->p[k+1]; k--; 
    }
    ap->r[k+1] = reg; (ap->n)++;     
    reg = NULL; // @{\it transfere a posse da mem\'oria}@
    ap->p[k+2] = apDir; 
    apDir = NULL; // @{\it transfere a posse da mem\'oria}@      
  }
  
  template <class TipoChave>  
  typename ArvoreB<TipoChave>::Pagina *ArvoreB<TipoChave>::
  insere (Item<TipoChave> *reg, Pagina *ap, Item<TipoChave> *&regRetorno, 
          bool &cresceu) {
    Pagina *apRetorno = NULL;
    if (ap == NULL) { cresceu = true; regRetorno = reg; } 
    else {
      int i = 0;
      while ((i < ap->n-1) && (reg->compara (ap->r[i]) > 0)) i++;      
      if (reg->compara (ap->r[i]) == 0) {
        cout << "Erro: Registro ja existente" << endl;
        cresceu = false;
      } 
      else {
        if (reg->compara (ap->r[i]) > 0) i++;
        apRetorno = insere (reg, ap->p[i], regRetorno, cresceu);
        if (cresceu)          
          if (ap->n < this->mm) { // @{\it P\'agina tem espa\c{c}o}@
            this->insereNaPagina (ap, regRetorno, apRetorno);
            cresceu = false; apRetorno = ap;
          } 
          else { // Overflow: @{\it P\'agina tem que ser dividida}@
            Pagina *apTemp = new Pagina (this->mm); apTemp->p[0] = NULL;
            if (i <= this->m) {
              this->insereNaPagina (apTemp, ap->r[this->mm-1], 
                                    ap->p[this->mm]);
              (ap->n)--;
              this->insereNaPagina (ap, regRetorno, apRetorno);
            } else this->insereNaPagina (apTemp, regRetorno, apRetorno);
            for (int j = this->m+1; j < this->mm; j++) {
              this->insereNaPagina (apTemp, ap->r[j], ap->p[j+1]);
            }
            ap->n = this->m; apTemp->p[0] = ap->p[this->m+1]; 
            regRetorno = ap->r[this->m]; apRetorno = apTemp;
          }
      }        
    }
    return (cresceu ? apRetorno : ap);
  }
  
template <class TipoChave> bool ArvoreB<TipoChave>::
reconstitui (Pagina *apPag, Pagina *apPai, int posPai) {
  bool diminuiu = true;
  if (posPai < apPai->n) { // @{\it aux = P\'agina a direita de apPag}@
    Pagina *aux = apPai->p[posPai+1];
    int dispAux = (aux->n - this->m + 1)/2;
    apPag->r[(apPag->n)++] = apPai->r[posPai];
    apPai->r[posPai] = NULL; // @{\it transfere a posse da mem\'oria}@
    apPag->p[apPag->n] = aux->p[0];
    aux->p[0] = NULL; // @{\it transfere a posse da mem\'oria}@
    if (dispAux > 0) { // @{\it Existe folga: transfere de aux para apPag}@
      for (int j = 0; j < dispAux - 1; j++) {
        this->insereNaPagina (apPag, aux->r[j], aux->p[j+1]);
      }
      apPai->r[posPai] = aux->r[dispAux - 1];
      aux->r[dispAux - 1] = NULL; // @{\it transfere a posse da mem\'oria}@
      aux->n = aux->n - dispAux;
      for (int j = 0;  j < aux->n; j++) {
        aux->r[j] = aux->r[j+dispAux];
        aux->r[j+dispAux] = NULL; // @{\it transfere a posse da mem\'oria}@
      }
      for (int j = 0; j <= aux->n; j++) {
        aux->p[j] = aux->p[j+dispAux];           
        aux->p[j+dispAux] = NULL; // @{\it transfere a posse da mem\'oria}@
      }
      diminuiu = false;
    }
    else { // @{\it Fus\~ao: intercala aux em apPag e libera aux}@
      for (int j = 0; j < this->m; j++) {
        this->insereNaPagina (apPag, aux->r[j], aux->p[j+1]);
      }
      delete aux; // @{\it libera aux}@
      apPai->p[posPai+1] = NULL; 
      for (int j = posPai; j < apPai->n-1; j++) {
        apPai->r[j] = apPai->r[j+1]; apPai->p[j+1] = apPai->p[j+2]; 
      }
      apPai->r[apPai->n-1] = NULL; // @{\it transfere a posse da mem\'oria}@
      apPai->p[apPai->n--] = NULL; // @{\it transfere a posse da mem\'oria}@
      diminuiu = apPai->n < this->m;
    }      
  }
  else { // @{\it aux = P\'agina a esquerda de apPag}@
    Pagina *aux = apPai->p[posPai-1];      
    int dispAux = (aux->n - this->m + 1)/2;
    for (int j = apPag->n-1; j >= 0; j--) apPag->r[j+1] = apPag->r[j];
    apPag->r[0] = apPai->r[posPai-1];
    apPai->r[posPai-1] = NULL; // @{\it transfere a posse da mem\'oria}@
    for (int j = apPag->n; j >= 0; j--) apPag->p[j+1] = apPag->p[j];
    apPag->p[0] = NULL; // @{\it transfere a posse da mem\'oria}@
    (apPag->n)++;
    if (dispAux > 0) { // @{\it Existe folga: transfere de aux para apPag}@
      for (int j = 0; j < dispAux - 1; j++) {
        this->insereNaPagina (apPag, aux->r[aux->n-j-1], aux->p[aux->n-j]);
      }
      apPag->p[0] = aux->p[aux->n - dispAux + 1];
      aux->p[aux->n - dispAux + 1] = NULL; // @{\it transfere a posse da mem\'oria}@
      apPai->r[posPai-1] = aux->r[aux->n - dispAux];
      aux->r[aux->n - dispAux] = NULL; // @{\it transfere a posse da mem\'oria}@
      aux->n = aux->n - dispAux; diminuiu = false;
    } 
    else { // @{\it Fus\~ao: intercala apPag em aux e libera apPag}@
      for (int j = 0; j < this->m; j++) {
        this->insereNaPagina (aux, apPag->r[j], apPag->p[j+1]);
      }
      delete apPag; // @{\it libera apPag}@
      apPai->p[(apPai->n)--] = NULL; // @{\it transfere a posse da mem\'oria}@
      diminuiu = apPai->n < this->m;
    }      
  }
  return diminuiu;
}

  template <class TipoChave>  
  bool ArvoreB<TipoChave>::antecessor (Pagina *ap, int ind,Pagina *apPai) {
    bool diminuiu = true;
    if (apPai->p[apPai->n] != NULL) {
      diminuiu = antecessor (ap, ind, apPai->p[apPai->n]);
      if (diminuiu) 
        diminuiu = reconstitui (apPai->p[apPai->n], apPai, apPai->n);
    }
    else {      
      delete ap->r[ind]; ap->r[ind] = apPai->r[--(apPai->n)]; 
      apPai->r[apPai->n] = NULL;  // @{\it transfere a posse da mem\'oria}@
      diminuiu = apPai->n < this->m;
    }
    return diminuiu;
  }

  template <class TipoChave>  
  typename ArvoreB<TipoChave>::Pagina *ArvoreB<TipoChave>::
  retira (Item<TipoChave> *reg, Pagina *ap, bool & diminuiu) {
    if (ap == NULL) {
      cout << "Erro: Registro nao encontrado" << endl;
      diminuiu = false;
    }
    else {
      int ind = 0;
      while ((ind < ap->n-1) && (reg->compara (ap->r[ind]) > 0)) ind++;
      if (reg->compara (ap->r[ind]) == 0) { // @{\it achou}@
        if (ap->p[ind] == NULL) { // @{\it P\'agina folha}@
          ap->n--; diminuiu = ap->n < this->m; delete ap->r[ind];
          for (int j = ind; j < ap->n; j++) {
            ap->r[j] = ap->r[j+1]; ap->p[j] = ap->p[j+1];
          }
          ap->p[ap->n] = ap->p[ap->n+1]; 
          ap->r[ap->n] = NULL; // @{\it transfere a posse da mem\'oria}@
          ap->p[ap->n+1] = NULL; // @{\it transfere a posse da mem\'oria}@
        }
        else { // @{\it P\'agina n\~ao \'e folha: trocar com antecessor}@
          diminuiu = antecessor (ap, ind, ap->p[ind]);
          if (diminuiu) diminuiu = reconstitui (ap->p[ind], ap, ind);          
        }
      }
      else { // @{\it n\~ao achou}@
        if (reg->compara (ap->r[ind]) > 0) ind++;
        ap->p[ind] = retira (reg, ap->p[ind], diminuiu);
        if (diminuiu) diminuiu = reconstitui (ap->p[ind], ap, ind);
      }
    }
    return ap;
  }
    
  template <class TipoChave>  
  ArvoreB<TipoChave>::ArvoreB (int m) {
    this->raiz = NULL; this->m = m; this->mm = 2*m;
  }
  
  template <class TipoChave>  
  Item<TipoChave> *ArvoreB<TipoChave>::pesquisa(Item<TipoChave> *reg)const{
    return this->pesquisa (reg, this->raiz);
  }

  template <class TipoChave>  
  void ArvoreB<TipoChave>::insere (Item<TipoChave> *reg) {
    Item<TipoChave> *regRetorno = NULL;
    bool cresceu = false;
    Pagina *apRetorno = this->insere (reg,this->raiz,regRetorno,cresceu);
    if (cresceu) {
      Pagina *apTemp = new Pagina(this->mm);
      apTemp->r[0] = regRetorno;
      apTemp->p[0] = this->raiz;
      apTemp->p[1] = apRetorno;
      this->raiz = apTemp; (this->raiz->n)++;
    } else this->raiz = apRetorno;
  }

  template <class TipoChave>  
  void ArvoreB<TipoChave>::retira (Item<TipoChave> *reg) {
    bool diminuiu = false;
    this->raiz = this->retira (reg, this->raiz, diminuiu);
    if (diminuiu && (this->raiz->n == 0)) { // @{\it \'Arvore diminui na altura}@
      Pagina *aux = this->raiz;
      this->raiz = this->raiz->p[0];
      delete aux;
    }
  }
  
  template <class TipoChave>  
  void ArvoreB<TipoChave>::imprime () const {
    cout << "ARVORE:" << endl;
    this->imprime (this->raiz, 0);
  }

  template <class TipoChave>  
  void ArvoreB<TipoChave>::liberaMemoria (Pagina *ap) {
    if (ap != NULL) {
      for(int i = 0; i <= ap->n; i++) liberaMemoria (ap->p[i]); 
      delete ap;
    }
  }

  template <class TipoChave>  
  ArvoreB<TipoChave>::~ArvoreB () {
    this->liberaMemoria (this->raiz);
  }
}
#endif
