package cap6;
import cap4.Item; // @{\it vide Programa~\ref{prog:interfaceitem}}@
public class ArvoreBEstrela  {
  private static abstract class Pagina {
    int n; Item chaves[]; 
  }
  private static class PaginaInt extends Pagina {
    Pagina p[]; 
    public PaginaInt (int mm) {
      this.n = 0; this.chaves = new Item[mm]; 
      this.p = new Pagina[mm+1];
    }
  }
  private static class PaginaExt extends Pagina {
    Object registros[]; 
    public PaginaExt (int mm2) {
      this.n = 0; this.chaves = new Item[mm2]; 
      this.registros = new Object[mm2]; 
    }
  }
  private Pagina raiz;
  private int mm, mm2;

  // @{\it Verifica se ap \'e uma p\'agina interna}@ 
  private boolean eInterna (Pagina ap) {    
    Class classe = ap.getClass ();
    return classe.getName().equals(PaginaInt.class.getName());
  }

  private Object pesquisa (Item chave, Pagina ap) {
    if (ap == null) return null; // Registro @{\it n\~ao}@ econtrado
    else {
      if (this.eInterna (ap)) {
        int i = 0; PaginaInt aux = (PaginaInt)ap;
        while ((i < aux.n-1) && (chave.compara (aux.chaves[i]) > 0)) i++;
        if (chave.compara (aux.chaves[i]) < 0) return pesquisa (chave, aux.p[i]);
        else return pesquisa (chave, aux.p[i+1]);
      }
      else {
        int i = 0; PaginaExt aux = (PaginaExt)ap;
        while ((i < aux.n-1) && (chave.compara (aux.chaves[i]) > 0)) i++;
        if (chave.compara (aux.chaves[i]) == 0) return aux.registros[i];
        return null; // Registro @{\it n\~ao}@ econtrado
      }
    }
  }
  
  public ArvoreBEstrela (int mm, int mm2) {
    this.raiz = null; this.mm = mm; this.mm2 = mm2;
  }
  
  public Object pesquisa (Item chave) {
    return this.pesquisa (chave, this.raiz);
  }
}
