#ifndef CFC_H_
#define CFC_H_
#include "listaadj/autoreferencia/Grafo.h" // @{\it vide Programa~\ref{c_7.4}@
#include "BuscaEmProfundidade.h" // @{\it vide Programa~\ref{c_7.9}@
#include <iostream>
using std::cout;
using std::endl;
using cap7_listaadj_autoreferencia::Grafo; // @{\it vide Programa~\ref{c_7.4}@
namespace cap7 {
	class Cfc	{
	private:
	  class TempoTermino {
	  friend class Cfc;
	  private:
	    int numRestantes, numVertices, *t;
	    bool *restantes;
	  public:
	   TempoTermino (int numVertices) {
	      this->t = new int[numVertices];      
	      this->restantes = new bool[numVertices];
	      this->numVertices = this->numRestantes = numVertices;
	    }
	    int maxTT () {
	      int vMax = 0;
	      while (!this->restantes[vMax]) vMax++;
	      for (int i = 0; i < this->numVertices; i ++) {
	        if (this->restantes[i]) {
	          if (this->t[i] > this->t[vMax]) vMax = i;
	        }
	      }
	      return vMax;
	    }
	    ~TempoTermino () {
	    	delete [] t; delete [] restantes;
	    }
	  };
	  Grafo *grafo;
	  void visitaDfs (Grafo *grafo, int u, TempoTermino *tt) const;
	public:
	  Cfc (Grafo *grafo);
	  void obterCfc () const;  
	  ~Cfc ();
	};
  void Cfc::visitaDfs (Grafo *grafo, int u, TempoTermino *tt) const {
    tt->restantes[u] = false; (tt->numRestantes) --;    
    cout << "  Vertice: " << u << endl;
    if (!grafo->listaAdjVazia (u)) {
      Grafo::Aresta *a = grafo->primeiroListaAdj (u);
      while (a != NULL) {
        int v = a->_v2 ();
        if (tt->restantes[v]) { this->visitaDfs (grafo, v, tt); }
        delete a; a = grafo->proxAdj (u);
      }
    }
  }
  Cfc::Cfc (Grafo *grafo) { this->grafo = grafo; }
  void Cfc::obterCfc () const {
    BuscaEmProfundidade dfs (this->grafo);
    dfs.buscaEmProfundidade ();
    TempoTermino *tt = new TempoTermino (this->grafo->_numVertices ());
    for (int u = 0; u < this->grafo->_numVertices (); u++) {
      tt->t[u] = dfs._t (u); tt->restantes[u] = true;
    }   
    cout << endl;
    Grafo *grafoT = this->grafo->grafoTransposto ();
    while (tt->numRestantes > 0) {
      int vRaiz = tt->maxTT ();
      cout << "Raiz da proxima arvore: " << vRaiz << endl;
      this->visitaDfs (grafoT, vRaiz, tt);
    }
    delete tt; delete grafoT;
  }  
  Cfc::~Cfc () { this->grafo = NULL; }
}
#endif 
