#ifndef AGMPRIM_H_
#define AGMPRIM_H_
#include "listaadj/autoreferencia/Grafo.h" // @{\it vide Programa~\ref{c_7.4}@
#include "FPHeapMinIndireto.h" // @{\it vide Programa~\ref{c_7.17}@
#include <float.h>
#include <iostream>
using std::cout;
using std::endl;
using cap7_listaadj_autoreferencia::Grafo; // @{\it vide Programa~\ref{c_7.4}@
namespace cap7 {
	class AgmPrim {
  private:
    int *antecessor;
    double *p;
    Grafo *grafo;
  public: 
    AgmPrim (Grafo *grafo);
	  void obterAgm (int raiz) throw (logic_error);
	  int _antecessor (int u) const;
	  double _peso (int u) const;
	  void imprime () const;
    ~AgmPrim ();
	};
  AgmPrim::AgmPrim (Grafo *grafo) { 
  	this->grafo = grafo; 
  	this->antecessor = NULL; this->p = NULL;
  }  
  void AgmPrim::obterAgm (int raiz) throw (logic_error) {
    int n = this->grafo->_numVertices();
    if (this->p) delete [] this->p;
    this->p = new double[n]; // @{\it peso dos v\'ertices}@
    int *vs = new int[n+1]; // @{\it v\'ertices}@
    bool *itensHeap = new bool[n]; 
    if (this->antecessor) delete [] this->antecessor;
    this->antecessor = new int[n];
    for (int u = 0; u < n; u ++) {
      this->antecessor[u] = -1;
      p[u] = DBL_MAX; // @$\infty$@
      vs[u+1] = u; // @{\it Heap indireto a ser constru\'{\i}do}@
      itensHeap[u] = true;
    }
    p[raiz] = 0;
    FPHeapMinIndireto heap (p, vs, n); heap.constroi ();
    while (!heap.vazio ()) {
      int u = heap.retiraMin (); itensHeap[u] = false;
      if (!this->grafo->listaAdjVazia (u)) {
        Grafo::Aresta *adj = grafo->primeiroListaAdj (u);
        while (adj != NULL) {
          int v = adj->_v2 ();
          if (itensHeap[v] && (adj->_peso () < this->_peso (v))) {
            antecessor[v] = u; heap.diminuiChave (v, adj->_peso ());
          }
          delete adj; adj = grafo->proxAdj (u);
        }
      }
    }
    delete [] vs; delete [] itensHeap;
  }
  int AgmPrim::_antecessor (int u) const { return this->antecessor[u]; }
  double AgmPrim::_peso (int u) const { return this->p[u]; }
  void AgmPrim::imprime () const {
    for (int u = 0; u < this->grafo->_numVertices(); u++)
      if (this->antecessor[u] != -1) 
        cout << "(" << antecessor[u] << "," << u << 
                ") -- p:" << _peso (u) << endl;
  }
  AgmPrim::~AgmPrim () { 
  	this->grafo = NULL;    	
    if (this->p) delete [] this->p;
  	if (this->antecessor) delete [] this->antecessor; 
  }  
}
#endif
