#ifndef GRAFO_H_
#define GRAFO_H_
#include <iostream>
using std::cout;
using std::endl;
namespace cap7_listaadj_arranjo {
	class Grafo {
	public:
		class Aresta {
	  private:
	    int v1, v2, peso; 
	  public: 
	    Aresta (int v1, int v2, int peso) {
	      this->v1 = v1; this->v2 = v2; this->peso = peso;
	    }
	    int _peso () { return this->peso; }
	    int _v1 () { return this->v1; }
	    int _v2 () { return this->v2; }
	    ~Aresta () {}
	  };
	private:
    int *cab, *prox, *peso;
    int *pos; // @{\it posi\c{c}\~ao atual ao se percorrer os adjs de um v\'ertice v}@
    int maxTam, numVertices, proxDisponivel;

  public:
    Grafo (int numVertices);	  
    Grafo (int numVertices, int numArestas);	  
	  void insereAresta (int v1, int v2, int peso);
	  bool existeAresta (int v1, int v2) const;
	  bool listaAdjVazia (int v) const;
	  Aresta *primeiroListaAdj (int v);
	  Aresta *proxAdj (int v);
	  Aresta *retiraAresta (int v1, int v2);
	  void imprime () const ;
	  int _numVertices () const;
	  Grafo *grafoTransposto ();
    ~Grafo ();	  
	};
  Grafo::Grafo (int numVertices) {
    int numArestas = 4500;
    this->maxTam = numVertices + 2*numArestas;
    this->cab  = new int[maxTam]; this->prox = new int[maxTam];
    this->peso = new int[maxTam]; this->numVertices = numVertices;
    this->pos = new int[this->numVertices];
    for (int i = 0; i < this->numVertices; i++) {
      this->prox[i] = 0; this->cab[i] = i; 
      this->peso[i] = 0; this->pos[i] = i; 
    }
    this->proxDisponivel = this->numVertices;
  }	  
  Grafo::Grafo (int numVertices, int numArestas) {
    this->maxTam = numVertices + 2*numArestas;
    this->cab  = new int[maxTam]; this->prox = new int[maxTam];
    this->peso = new int[maxTam]; this->numVertices = numVertices;
    this->pos = new int[this->numVertices];
    for (int i = 0; i < this->numVertices; i++) {
      this->prox[i] = 0; this->cab[i] = i; 
      this->peso[i] = 0; this->pos[i] = i; 
    }
    this->proxDisponivel = this->numVertices;
  }	  
  
  void Grafo::insereAresta (int v1, int v2, int peso) {
    if (this->proxDisponivel == this->maxTam)
      cout << "Nao ha espaco disponivel para a aresta" << endl;
    else {
      int ind = (this->proxDisponivel)++;
      this->prox[this->cab[v1]] = ind;
      this->cab[ind] = v2; this->cab[v1] = ind;
      this->prox[ind] = 0; this->peso[ind] = peso; 
    }
  }
  bool Grafo::existeAresta (int v1, int v2) const {
    for (int i = this->prox[v1]; i != 0; i = this->prox[i])
      if (this->cab[i] == v2) return true;
    return false;
  }
  bool Grafo::listaAdjVazia (int v) const {
    return (this->prox[v] == 0);
  }	  
  Grafo::Aresta *Grafo::primeiroListaAdj (int v) {
    // @{\it Retorna a primeira aresta que o v\'ertice v participa ou}@
    // @{\it {\bf NULL} se a lista de adjac\^encia de v for vazia}@
    this->pos[v] = v;
    return this->proxAdj (v);
  }
  Grafo::Aresta *Grafo::proxAdj (int v) {
    // @{\it Retorna a pr\'oxima aresta que o v\'ertice v participa ou}@
    // @{\it {\bf NULL} se a lista de adjac\^encia de v estiver no fim}@
    this->pos[v] = this->prox[this->pos[v]];
    if (this->pos[v] == 0) return NULL;
    else return new Aresta (v,this->cab[pos[v]],this->peso[pos[v]]);     
  }
  Grafo::Aresta *Grafo::retiraAresta (int v1, int v2) {
    int i;
    for (i = v1; this->prox[i] != 0; i = this->prox[i])
      if (this->cab[this->prox[i]] == v2) break;
    int ind = this->prox[i];
    if (this->cab[ind] == v2) { // @{\it encontrou aresta}@
      Aresta *aresta = new Aresta(v1, v2, this->peso[ind]);
      this->cab[ind] = this->maxTam; // @{\it marca como removido}@
      if (this->prox[ind] == 0) this->cab[v1] = i; // @{\it \'ultimo v\'ertice}@
      this->prox[i] = this->prox[ind];
      return aresta;
    } else return NULL;
  }
  void Grafo::imprime () const {
    for (int i = 0; i < this->numVertices; i++) { 
      cout << "Vertice " << i << ":" << endl;
      for (int j = this->prox[i]; j != 0; j = this->prox[j])
        cout << "  " << this->cab[j] << " (" << this->peso[j] << ")" << endl;
    }
  }
  int Grafo::_numVertices () const { return this->numVertices; }
  Grafo *Grafo::grafoTransposto () {
    Grafo *grafoT = new Grafo (this->numVertices); 
    for (int v = 0; v < this->numVertices; v++)
      if (!this->listaAdjVazia (v)) {
        Aresta *adj = this->primeiroListaAdj (v);
        while (adj != NULL) {
          grafoT->insereAresta (adj->_v2 (), adj->_v1 (), adj->_peso ());
          delete adj;
          adj = this->proxAdj (v);
        }
      }
    return grafoT;
  }
  Grafo::~Grafo () {
    delete [] cab;  delete [] prox;
    delete [] peso; delete [] pos;
  }	  
}

#endif 

		
