#ifndef _TESTAHIPERGRAFO_H_
#define _TESTAHIPERGRAFO_H_
#include "listincidencia/HiperGrafo.h" // @{\it vide Programa~\ref{prog:tipoabstratohipergrafoc}@
#include <iostream>
using std::cout;
using std::cin;
using std::endl;
using cap7_listincidencia::HiperGrafo; // @{\it vide Programa~\ref{prog:tipoabstratohipergrafoc}@
namespace cap7 {
  class TestaHiperGrafo {
  public:
    static HiperGrafo::Aresta *lerAresta (int r);
    static void main ();    
  };
  HiperGrafo::Aresta *TestaHiperGrafo::lerAresta (int r) {
    cout << "Aresta:" << endl;
    int *vertices = new int[r];
    for (int i = 0; i < r; i++) {
      cout << "  V" << i << ":"; 
      cin >> vertices[i];
    }
    cout << "  Peso:";
    int peso = 0; cin >> peso;
    HiperGrafo::Aresta * aresta = new HiperGrafo::Aresta (vertices, 
                                                          peso, r);
    delete vertices; return aresta;
  }
  void TestaHiperGrafo::main () {
    cout << "No. vertices:"; int nVertices = 0;
    cin >> nVertices;
    cout << "No. arestas:"; int nArestas = 0;
    cin >> nArestas;
    cout << "r:"; int r = 0;
    cin >> r;
    HiperGrafo *grafo = new HiperGrafo (nVertices, nArestas, r);
    for (int i = 0; i < nArestas; i++) {
      HiperGrafo::Aresta *a = lerAresta (r);
      grafo->insereAresta (a->_vertices (), a->_peso ());   
      delete a;
    }
    grafo->imprime ();  
    cout << "Lista de arestas incidentes em: "; int v1 = 0;
    cin >> v1;
    if (!grafo->listaIncVazia (v1)) {
      HiperGrafo::Aresta *adj = grafo->primeiraListaInc (v1);
      while (adj != NULL) {
       cout << "  " << *adj << endl;
       adj = grafo->proxInc (v1);       
      }
      cout << endl;
    }    
    cout << "Retira aresta: " << endl;
    HiperGrafo::Aresta *a = lerAresta (r);
    if (grafo->existeAresta (a->_vertices ())) {
      HiperGrafo::Aresta *b = grafo->retiraAresta (a->_vertices ());
      HiperGrafo::Aresta *c = grafo->retiraAresta (a->_vertices ()); 
      cout << "aresta b: " << *b << endl; delete b; 
      if (c) {
        cout << "aresta c: " << *c << endl; delete c;
      }
      else  cout << "aresta c: NULL" << endl;

    }    
    else cout << "Aresta nao existe" << endl;
    delete a; grafo->imprime ();
    cout << "Existe aresta: " << endl; a = lerAresta (r);
    if (grafo->existeAresta (a->_vertices ())) 
     cout << "  Sim" << endl;
    else cout << "  Nao" << endl;
    delete a; delete grafo;
  }
}
#endif
